/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * 业务分类Entity
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
public class SysBusinessCate extends DataEntity<SysBusinessCate> {

    private static final long serialVersionUID = 1L;
    // 分类名称
    private String cateName;
    // 分类编号
    private String cateCode;
    // 排序
    private String sort;

    public SysBusinessCate() {
        super();
    }

    public SysBusinessCate(String id) {
        super(id);
    }

    @Length(min = 1, max = 32, message = "分类名称长度必须介于 1 和 32 之间")
    public String getCateName() {
        return cateName;
    }

    public void setCateName(String cateName) {
        this.cateName = cateName;
    }

    @Length(min = 1, max = 32, message = "分类编号长度必须介于 1 和 32 之间")
    public String getCateCode() {
        return cateCode;
    }

    public void setCateCode(String cateCode) {
        this.cateCode = cateCode;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}