/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.finance.entity.PaymentOrderProject;
import com.cku.oa.finance.service.PaymentOrderProjectService;

import java.util.List;

/**
 * 订单项目Controller
 * @author lyy
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentOrderProject")
public class PaymentOrderProjectController extends BaseController {

	@Autowired
	private PaymentOrderProjectService paymentOrderProjectService;
	
	@ModelAttribute
	public PaymentOrderProject get(@RequestParam(required=false) String id) {
		PaymentOrderProject entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = paymentOrderProjectService.get(id);
		}
		if (entity == null){
			entity = new PaymentOrderProject();
		}
		return entity;
	}
	
	@RequiresPermissions("finance:paymentOrderProject:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentOrderProject paymentOrderProject, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentOrderProject> page = paymentOrderProjectService.findPage(new Page<PaymentOrderProject>(request, response), paymentOrderProject); 
		model.addAttribute("page", page);
		return "oa/finance/paymentOrderProjectList";
	}
	@RequiresPermissions("finance:paymentOrderProject:view")
	@RequestMapping(value = "statistical")
	public String statistical(PaymentOrderProject paymentOrderProject, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<PaymentOrderDetail> list = paymentOrderProjectService.statistical(paymentOrderProject);
		model.addAttribute("list", list);
		return "oa/finance/paymentOrderProjectStatistical";
	}
	@RequiresPermissions("finance:paymentOrderProject:view")
	@RequestMapping(value = "form")
	public String form(PaymentOrderProject paymentOrderProject, Model model) {

		model.addAttribute("paymentOrderProject", paymentOrderProject);
		return "oa/finance/paymentOrderProjectForm";
	}

	@RequiresPermissions("finance:paymentOrderProject:add")
	@RequestMapping(value = "save")
	public String save(PaymentOrderProject paymentOrderProject, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentOrderProject)){
			return form(paymentOrderProject, model);
		}
		paymentOrderProjectService.save(paymentOrderProject);
		addMessage(redirectAttributes, "保存订单项目成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentOrderProject/?repage";
	}
	@RequiresPermissions("finance:paymentOrderProject:add")
	@RequestMapping(value = "addOrderProjectRestful")
	@ResponseBody
	public String addOrderProjectRestful(PaymentOrderProject paymentOrderProject, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentOrderProject)){
			return form(paymentOrderProject, model);
		}
		paymentOrderProjectService.save(paymentOrderProject);
		return "ok";
	}
	@RequiresPermissions("finance:paymentOrderProject:changeStatus")
	@RequestMapping(value = "changeStatus")
	public String changeStatus(PaymentOrderProject paymentOrderProject, RedirectAttributes redirectAttributes){
		paymentOrderProjectService.changeStatus(paymentOrderProject);
		addMessage(redirectAttributes, "修改订单项目状态成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentOrderProject/?repage";
	}
	@RequiresPermissions("finance:paymentOrderProject:delete")
	@RequestMapping(value = "delete")
	public String delete(PaymentOrderProject paymentOrderProject, RedirectAttributes redirectAttributes) {
		paymentOrderProjectService.delete(paymentOrderProject);
		addMessage(redirectAttributes, "删除订单项目成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentOrderProject/?repage";
	}

}