package com.cku.oa.finance.dao.statistics;

import com.cku.oa.statistics.vo.RegionVo;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 财务统计数据查询
 * 
 * @author xuzhenxing
 *
 */
@MyBatisDao

public interface FinanceStatisticsDao {
	/**
	 * 财务收入，各项收入
	 * 
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	Map classification(@Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 * 财务收入，资金挂账
	 * 
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	double payOnAccount(@Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 * 财务收入，商城收入
	 * 
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	List<Map> e_mall(@Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 * 业务扣费
	 */
	List<Map> charge(@Param("startDate") String startDate, @Param("endDate") String endDate,
			@Param("officeNo") String officeNo);

	List<Map> regionCharge(@Param("startDate") String startDate, @Param("endDate") String endDate,
			@Param("province") String province, @Param("regions") List<RegionVo> regions);

	/**
	 * 部门名称,查询jeesite_sys_office
	 * 
	 * @order soft
	 * @return id office的ID
	 * @return name office的名称
	 */
	List<Map> officeName(@Param("officeNo") String officeNo);

	List<Map> regionOfficeName();

	/**
	 * 返回符合条件的订单总数
	 */
	Map countOrder(@Param("totalPrice") String totalPrice, @Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode, @Param("memberName") String memberName,
			@Param("orderType") String orderType, @Param("chargingItemID") String chargingItemID,
			@Param("projectID") String projectID, @Param("voucherCode") String voucherCode,
			@Param("paymentState") String paymentState, @Param("startDate") String startDate,
			@Param("endDate") String endDate);

	Map regionCountOrder(@Param("totalPrice") String totalPrice, @Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode, @Param("memberName") String memberName,
			@Param("orderType") String orderType, @Param("chargingItemID") String chargingItemID,
			@Param("projectID") String projectID, @Param("voucherCode") String voucherCode,
			@Param("paymentState") String paymentState, @Param("startDate") String startDate,
			@Param("endDate") String endDate, @Param("province") String province , @Param("regions") List<RegionVo> regions);

	/**
	 * 返回符合条件的订单详情
	 * 
	 */
	List<Map> orderList(@Param("totalPrice") String totalPrice, @Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode, @Param("memberName") String memberName,
			@Param("orderType") String orderType, @Param("chargingItemID") String chargingItemID,
			@Param("projectID") String projectID, @Param("voucherCode") String voucherCode,
			@Param("paymentState") String paymentState, @Param("startDate") String startDate,
			@Param("endDate") String endDate, @Param("pageNo") int pageNo, @Param("pageSize") int pageSize);

	List<Map> regionOrderList(@Param("totalPrice") String totalPrice, @Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode, @Param("memberName") String memberName,
			@Param("orderType") String orderType, @Param("chargingItemID") String chargingItemID,
			@Param("projectID") String projectID, @Param("voucherCode") String voucherCode,
			@Param("paymentState") String paymentState, @Param("startDate") String startDate,
			@Param("endDate") String endDate, @Param("pageNo") int pageNo, @Param("pageSize") int pageSize,
			@Param("province") String province ,@Param("regions") List<RegionVo> regions);

	/**
	 * 返回符合条件的订单详情
	 * 
	 */
	List<Map> orderAllList(@Param("totalPrice") String totalPrice, @Param("orderCode") String orderCode,
			@Param("memberCode") String memberCode, @Param("memberName") String memberName,
			@Param("orderType") String orderType, @Param("chargingItemID") String chargingItemID,
			@Param("projectID") String projectID, @Param("voucherCode") String voucherCode,
			@Param("paymentState") String paymentState, @Param("startDate") String startDate,
			@Param("endDate") String endDate);

	/**
	 * 返回所有的收费项目
	 */

	List<Map> chargeItemOption();

	List<Map> chargeCouponItemOption();

	/**
	 * 返回赛事的收费项目ID
	 */
	List<String> showChargeItemID();

	List<String> showChargeCouponItemID();

}
