package com.cku.oa.finance.cab;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.restlet.engine.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.finance.cab.dao.CABFinanceStatisticsDao;
import com.cku.oa.statistics.dao.SaPaymentDetailDao;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;


/**
 * 财务统计
 * @author xuzhenxing
 *
 */

@Controller
@RequestMapping(value = "${adminPath}/cab/")
public class CABFinanceStatisticsController {
	
	@Autowired
	private CABFinanceStatisticsDao financeStatisticsDao;
	@Autowired
	private SaPaymentDetailService saPaymentDetailService;
	@Autowired
	private SaPaymentDetailDao saPaymentDetailDao;
	
	private BigDecimal allCab = new BigDecimal(0);
	private BigDecimal allCku = new BigDecimal(0);
	private BigDecimal allOther = new BigDecimal(0);
	private BigDecimal allCsv = new BigDecimal(0);
	
	//新版本的拆帐实现
	@RequestMapping(value = "csvCharge")
	public String csvChargeView(HttpServletRequest request,HttpServletResponse response,Model model){
		allCab = new BigDecimal(0);
		allCsv = new BigDecimal(0);
		allOther = new BigDecimal(0);
		String nowDate = request.getParameter("nowDate");		
		String isOnSubmit = request.getParameter("isOnSubmit");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String type = request.getParameter("type");  //是否是查询待收款账户
		String source = request.getParameter("source");  //cab csv cku 分类显示
		
		
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		if(isOnSubmit == null || isOnSubmit.equals(""))
		{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}else if(isOnSubmit.equals("1")){
			if(nowDate == null || !nowDate.equals("")){
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate =  String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}
			}
		}
		
		if(StringUtils.isNotEmpty(type)&&type.equals("pedding")){
			startDate = DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");
			endDate = String.valueOf(year+100)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";//100年以后
		}
		
		Map<String,List<Map>>  paymentDetails= this.saPaymentDetailService.statisticsCsv(startDate, endDate);
		
		List<Map> officeCAB = financeStatisticsDao.officeCSV_CAB();	
		List<Map> officeCSV = financeStatisticsDao.officeCSV();	
		List<Map> packageCab = csvPackageData(paymentDetails.get("cab"),officeCAB,"cab");
		List<Map> packageCsv = csvPackageData(paymentDetails.get("csv"),officeCSV,"csv");
		
		
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("packageCab",packageCab);
		model.addAttribute("packageCsv",packageCsv);
		model.addAttribute("allCsv",allCsv);
		model.addAttribute("allCab",allCab);
		model.addAttribute("allOther",allOther);
		model.addAttribute("type",type);
		model.addAttribute("source",source);
		return "oa/cab/csvCharge";
	}
	
	/**
	 * 将数据解析的结果转为页面需要的格式
	 * @param cabResult
	 * @return
	 */
	private List<Map> csvPackageData(List<Map> result,List<Map> offices,String type){
		List<Map> packageData = new ArrayList<Map>();
		for(Map office:offices){
			String name = (String) office.get("name");
			String id = (String) office.get("id");
			Map totalData = new HashMap();
			List<Map> chargeList = new ArrayList<Map>();
			BigDecimal totalFee = new BigDecimal(0);
			
			for(Map map: result){
				String dept = (String) map.get("dept");
				BigDecimal countFee = (BigDecimal) map.get("countFee");
				try{
					if(dept.equals(id)){
						chargeList.add(map);
						totalFee = totalFee.add(countFee);
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			
			if(type.equals("csv")){
				allCsv = allCsv.add(totalFee);
			}
			if(type.equals("cab")){
				allCab = allCab.add(totalFee);
			}
			
			totalData.put("name",name);
			totalData.put("totalFee",totalFee);
			totalData.put("items",chargeList);
			packageData.add(totalData);
			
		}
		return packageData;
	}
	
	//新版本的拆帐实现
	@RequestMapping(value = "newCharge")
	public String newChargeView(HttpServletRequest request,HttpServletResponse response,Model model) {
		allCab = new BigDecimal(0);
		allCku = new BigDecimal(0);
		allOther = new BigDecimal(0);
		String nowDate = request.getParameter("nowDate");		
		String isOnSubmit = request.getParameter("isOnSubmit");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String type = request.getParameter("type");  //是否是查询待收款账户
		String source = request.getParameter("source");  //cab csv cku 分类显示

		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		if(isOnSubmit == null || isOnSubmit.equals(""))
		{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}else if(isOnSubmit.equals("1")){
			if(nowDate == null || !nowDate.equals("")){
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate =  String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}
			}
		}
		
		if(StringUtils.isNotEmpty(type)&&type.equals("pedding")){
			startDate = DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");
			endDate = String.valueOf(year+100)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";//100年以后
		}
		
		Map<String,List<Map>>  paymentDetails= this.saPaymentDetailService.statistics(startDate, endDate);
		
		List<Map> officeCAB = financeStatisticsDao.officeCAB();	
		List<Map> officeCKU = financeStatisticsDao.officeCKU();	
		List<Map> packageCab = newPackageData(paymentDetails.get("cab"),paymentDetails.get("cab_fine"),officeCAB,"cab");
		List<Map> packageCku = newPackageData(paymentDetails.get("cku"),paymentDetails.get("cku_fine"),officeCKU,"cku");
		
		//计算当期确认与当期未确认
		String confired = saPaymentDetailDao.currentConfired(startDate, endDate);
		String unConfired = saPaymentDetailDao.currentUnconfired(startDate, endDate);
		String shared = saPaymentDetailDao.currentShare(startDate, endDate);
		
		
		//CKU代收代付
		List<Map> ckuWanglai = new ArrayList<Map>();
		for(Map map:paymentDetails.get("cku")){
			
			String dept = (String) map.get("dept");
			if(dept.equals("daishoudaifu")){
				
				ckuWanglai.add(map);
			}
		}
		
		
		//赛事服务费，需要生成往来数据
		List<Map> wanglai = new ArrayList<Map>();
		for(Map map:paymentDetails.get("cab")){
			
			Map newMap = new HashMap();
			String dept = (String) map.get("dept");
			BigDecimal countFee = (BigDecimal) map.get("countFee");
			BigDecimal countNum = (BigDecimal) map.get("countNum");
			String id = (String)map.get("id");
			newMap.put(dept, dept);
			newMap.put("countNum", countNum);
			newMap.put("countPrice", 0);
			
			if(id.equals("cab65")){
				newMap.put("name","赛事合办（京）" );
				newMap.put("countFee", countFee.divide(new BigDecimal("0.15"),2,BigDecimal.ROUND_HALF_DOWN));
				
				wanglai.add(newMap);
			}
			if(id.equals("cab66")){
				newMap.put("name", "赛事合办（杭）");
				newMap.put("countFee", countFee.divide(new BigDecimal("0.15"),2,BigDecimal.ROUND_HALF_DOWN));
				wanglai.add(newMap);
			}
			if(id.equals("cab67")){
				newMap.put("name", "赛事合办（重庆）");
				newMap.put("countFee", countFee.divide(new BigDecimal("0.15"),2,BigDecimal.ROUND_HALF_DOWN));
				wanglai.add(newMap);
			}
		}
		
		
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("packageCab",packageCab);
		model.addAttribute("packageCku",packageCku);
		model.addAttribute("allCku",allCku);
		model.addAttribute("allCab",allCab);
		model.addAttribute("allOther",allOther);
		model.addAttribute("wanglai", wanglai);
		model.addAttribute("ckuWanglai",ckuWanglai);
		model.addAttribute("type",type);
		model.addAttribute("source",source);
		model.addAttribute("confired", confired);
		model.addAttribute("unconfired", unConfired);
		model.addAttribute("shared", shared);
		return "oa/cab/newCharge";
	}
	
	@RequestMapping(value="getDetail")
	public String paymentRecord(HttpServletRequest request,HttpServletResponse response,Model model){
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String type = request.getParameter("type");
		String chargeItemId = request.getParameter("chargeItemId");
		String name = request.getParameter("chargeItemName");
		
		SaPaymentDetail detail = new SaPaymentDetail();
		detail.setStartDate(startDate);
		detail.setEndDate(endDate);
		detail.setType(type);
		detail.setChargeItemId(chargeItemId);
		Page<SaPaymentDetail> page = saPaymentDetailService.findPage(new Page<SaPaymentDetail>(request, response),detail);
		
		model.addAttribute("page",page);
		model.addAttribute("name",name);
		model.addAttribute("saPaymentDetail",detail);
		model.addAttribute("chargeItemName",name);
		return "oa/cab/saPaymentDetailList";
	}
	
	@RequestMapping(value="getCsvDetail")
	public String csvPaymentRecord(HttpServletRequest request,HttpServletResponse response,Model model){
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String type = request.getParameter("type");
		String chargeItemId = request.getParameter("chargeItemId");
		String name = request.getParameter("chargeItemName");
		
		SaPaymentDetail detail = new SaPaymentDetail();
		detail.setStartDate(startDate);
		detail.setEndDate(endDate);
		detail.setType(type);
		detail.setChargeItemId(chargeItemId);
		Page<SaPaymentDetail> page = saPaymentDetailService.findCsvPage(new Page<SaPaymentDetail>(request, response),detail);
		
		model.addAttribute("page",page);
		model.addAttribute("name",name);
		model.addAttribute("saPaymentDetail",detail);
		model.addAttribute("chargeItemName",name);
		return "oa/cab/saPaymentDetailCsvList";
	}
	
	
	
	/**
	 * 将数据解析的结果转为页面需要的格式
	 * @param cabResult
	 * @return
	 */
	private List<Map> newPackageData(List<Map> result,List<Map> fineList,List<Map> offices,String type){
		List<Map> packageData = new ArrayList<Map>();
		for(Map office:offices){
			String name = (String) office.get("name");
			String id = (String) office.get("id");
			Map totalData = new HashMap();
			List<Map> chargeList = new ArrayList<Map>();
			BigDecimal totalFee = new BigDecimal(0);
			BigDecimal fineAmount = new BigDecimal("0");
			BigDecimal fineCount = new BigDecimal("0");
			
			for(Map map: result){
				String dept = (String) map.get("dept");
				BigDecimal countFee = (BigDecimal) map.get("countFee");
				try{
				if(dept.equals(id)&&!(name.equals("财务部")||name.equals("合作单位")||name.equals("代收代付"))){
					chargeList.add(map);
					totalFee = totalFee.add(countFee);
				}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			
			if(type.equals("cku")){
				allCku = allCku.add(totalFee);
			}
			if(type.equals("cab")){
				allCab = allCab.add(totalFee);
			}
			
			totalData.put("name",name);
			totalData.put("totalFee",totalFee);
			totalData.put("items",chargeList);
			packageData.add(totalData);
			
		}
		return packageData;
	}
	
	//旧版本的拆帐实现
	@RequestMapping(value = "charge")
	public String chargeView(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		allCab = new BigDecimal(0);
		allCku = new BigDecimal(0);
		allOther = new BigDecimal(0);
		String nowDate = request.getParameter("nowDate");		
		String isOnSubmit = request.getParameter("isOnSubmit");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		
		
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH )+1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		if(isOnSubmit == null || isOnSubmit.equals(""))
		{
			if(startDate == null || startDate.equals(""))
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
			if(endDate == null || endDate.equals(""))
				endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
		}else if(isOnSubmit.equals("1")){
			if(nowDate == null || !nowDate.equals("")){
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate =  String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
				}
			}
		}
		
		double chargeTotal = 0;	//业务扣费总计金额
		List<Map> officeCAB = financeStatisticsDao.officeCAB();	//部门名称
		List<Map> officeCKU = financeStatisticsDao.officeCKU();	//部门名称
		
		
		//数据库查询结果
		List<Map> chargeItems = financeStatisticsDao.charge(startDate, endDate);	//扣费项目
		List<Map> chargeCABs = financeStatisticsDao.cabChargeItem();
		List<Map> chargeCKUs = financeStatisticsDao.ckuChargeItem();
		List<Map> relationShips = financeStatisticsDao.relationShip();
		List<Map> cabOffice = financeStatisticsDao.officeCAB();
		List<Map> ckuOffice = financeStatisticsDao.officeCKU();
		
		//CAB的统计
		Map<String,Map> cabResult = new HashMap<String,Map>();
		
		//CKU的统计
		Map<String,Map> ckuResult = new HashMap<String,Map>();
		
		for(Map chargeItem:chargeItems){
			String chargeID = (String) chargeItem.get("chargeID");
			BigDecimal countNum = (BigDecimal) chargeItem.get("countNum");
			BigDecimal countFee = (BigDecimal) chargeItem.get("countFee");
			for(Map relationShip:relationShips){
				String id = (String) relationShip.get("id");
				String cab = (String) relationShip.get("CAB");
				String cku = (String) relationShip.get("CKU");
				String dept = (String) relationShip.get("dept");
				
				//匹配成功
				if(id.equals(chargeID)){
					
					List<Map> list = new ArrayList<Map>();
					//将CKU的收费结果整理出来
					if(StringUtils.isNotEmpty(cku)){
						if(cku.contains(",")){
							String[] ckuArray = cku.split(",");
							for(String ckuCharge : ckuArray){
								Map map = new HashMap();
								map.put("type","cku" );
								map.put("id", ckuCharge);
								map.put("dept", dept);
								list.add(map);
							}
						}else{
							Map map = new HashMap();
							map.put("type", "cku");
							map.put("id", cku);
							map.put("dept", dept);
							list.add(map);
						}
					}
					
					//将CAB的收费结果整理出来
					if(StringUtils.isNotEmpty(cab)){
						if(cab.contains(",")){
							String[] cabArray = cab.split(",");
							for(String cabCharge : cabArray){
								Map map = new HashMap();
								map.put("type", "cab");
								map.put("id", cabCharge);
								map.put("dept", dept);
								list.add(map);
							}
						}else{
							Map map = new HashMap();
							map.put("type", "cab");
							map.put("id", cab);
							map.put("dept", dept);
							list.add(map);
						}
					}
					
					
					//分账功能
					BigDecimal totalMoney = new BigDecimal(0);
					for(int i=0;i<list.size();i++){
						Map map = list.get(i);
						String type = (String) map.get("type");
						String chargeId = (String) map.get("id");
						
						if(list.size() == 1){
							//只有一个收费项，不需要分账
							if(type.equals("cku")){
								getChargeInfo(chargeId,countNum,countFee,dept,ckuResult,chargeCKUs,countFee,true);
							}else if(type.equals("cab")){
								getChargeInfo(chargeId,countNum,countFee,dept,cabResult,chargeCABs,countFee,true);
							}
						}else{
							//有多个收费项，最后一个收费项的计算是减去前面的所有的收费
							BigDecimal remaining = countFee.subtract(totalMoney);
							if(i+1 == list.size()){
								
								if(type.equals("cku")){
									totalMoney = totalMoney.add(getChargeInfo(chargeId,countNum,countFee,dept,ckuResult,chargeCKUs,remaining,true));
								}else if(type.equals("cab")){
									totalMoney = totalMoney.add(getChargeInfo(chargeId,countNum,countFee,dept,cabResult,chargeCABs,remaining,true));
								}
							}else{
								if(type.equals("cku")){
									totalMoney = totalMoney.add(getChargeInfo(chargeId,countNum,countFee,dept,ckuResult,chargeCKUs,remaining,false));
								}else if(type.equals("cab")){
									totalMoney = totalMoney.add(getChargeInfo(chargeId,countNum,countFee,dept,cabResult,chargeCABs,remaining,false));
								}
							}
						}
					}
					break;
				}
			}
		}
		
		List<Map> packageCab = packageData(cabResult,officeCAB,"cab");
		List<Map> packageCku = packageData(ckuResult,officeCKU,"cku");
		
//		model.addAttribute("chargeTotal",chargeTotal);
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("packageCab",packageCab);
		model.addAttribute("packageCku",packageCku);
		model.addAttribute("allCku",allCku);
		model.addAttribute("allCab",allCab);
		model.addAttribute("allOther",allOther);
		return "oa/cab/charge";
	}
//
	/**
	 * 
	 * @param chargeId 新的收费项id
	 * @param oldCountNum 旧收费项的数量
	 * @param oldCountFee 旧收费项的总金额
	 * @param resultMap 新的收费项的结果集合，分cku集合与cab集合
	 * @param chargeInfoMap 新收费项的详情，分cku结合与cku集合
	 * @param remaining  当前收费项还剩余的未分配金额
	 * @return
	 */
	private BigDecimal getChargeInfo(String chargeId,BigDecimal oldCountNum,BigDecimal oldCountFee,String dept,Map<String,Map> resultMap,List<Map> chargeInfoMap,BigDecimal remaining,boolean isLast){
		//代码说明
		//realFee 实收金额， totalFee 应收金额，remaining  一个旧收费项被拆分为多个收费项，这个是拆分到当前收费项的时候还剩余的总金额 
		//countFee  一个新收费项可能对应多个旧收费项，countFee为多个旧收费项的总合
		
		Map  map = resultMap.get(chargeId);
		if(map == null){
			map = new HashMap();
		}
		
		
		BigDecimal countNum = (BigDecimal) map.get("countNum");
		BigDecimal countFee = (BigDecimal) map.get("countFee");
		BigDecimal totalFee = new BigDecimal(0);
		BigDecimal fee = new BigDecimal(0);
		
		//封装其他收费项信息
		for(Map infoMap:chargeInfoMap){
			String infoId = (String) infoMap.get("id");
			if(infoId.equals(chargeId)){
				map.put("name", infoMap.get("chargingItemName"));
				map.put("dept", infoMap.get("dept"));
				map.put("price", infoMap.get("price"));
				fee = new BigDecimal((String)infoMap.get("price"));
			}
		}
		map.put("id", chargeId);
		
		if(countNum == null){
			countNum = oldCountNum;
			map.put("countNum",countNum );
		}else{
			countNum = oldCountNum.add(countNum);
			map.put("countNum", countNum);
		}
		totalFee = oldCountNum.multiply(fee);
		BigDecimal realFee = new BigDecimal(0);
		
		if(!isLast){
			if(totalFee.compareTo(remaining)>= 0){
				realFee = remaining;
			}else{
				realFee = totalFee;
			}
		}else{
			if(totalFee.compareTo(remaining)<0){
				//应收大于实收，多余的费用存放到扣费
				realFee = totalFee;
				BigDecimal reduceFee = remaining.subtract(totalFee);
				addToExtreaFee(countNum,reduceFee,(String)map.get("dept"),resultMap);
			}else{
				realFee = remaining;
			}
		}
		map.put("remaining", remaining);
		map.put("realFee", realFee);
		
		if(countFee == null){
			countFee = realFee;
			map.put("countFee", countFee);
		}else{
			countFee = realFee.add(countFee);
			map.put("countFee", countFee);
		}
		resultMap.put(chargeId,map );
		
		return realFee;
	}
	
	/**
	 * 多余的费用要添加到罚款里
	 * @param num
	 * @param decimal
	 * @param officeId
	 * @param resultMap
	 */
	private void addToExtreaFee(BigDecimal num,BigDecimal decimal,String officeId,Map<String,Map> resultMap){
		Map  map = resultMap.get(officeId);
		if(map == null){
			map = new HashMap();
		}
		
		BigDecimal countNum = (BigDecimal) map.get("countNum");
		BigDecimal countFee = (BigDecimal) map.get("countFee");
		
		if(countNum == null){
			countNum = num;
			map.put("countNum",countNum );
		}else{
			countNum = num.add(countNum);
			map.put("countNum", countNum);
		}
		
		if(countFee == null){
			map.put("countFee", decimal);
		}else{
			countFee = decimal.add(countFee);
			map.put("countFee", countFee);
		}
		map.put("name", "罚款");
		map.put("price",0);
		map.put("dept", officeId);
		
		resultMap.put(officeId, map);
	}
	
	/**
	 * 将数据解析的结果转为页面需要的格式
	 * @param cabResult
	 * @return
	 */
	private List<Map> packageData(Map<String, Map> result,List<Map> offices,String type){
		List<Map> packageData = new ArrayList<Map>();
		
		for(Map office:offices){
			String name = (String) office.get("name");
			String id = (String) office.get("id");
			Map totalData = new HashMap();
			List<Map> chargeList = new ArrayList<Map>();
			BigDecimal totalFee = new BigDecimal(0);
			for(Map.Entry entry:result.entrySet()){
				Map map = (Map) entry.getValue();
				String dept = (String) map.get("dept");
				BigDecimal countFee = (BigDecimal) map.get("countFee");
				if(dept.equals(id)&&!(name.equals("财务部")||name.equals("合作单位"))){
					chargeList.add(map);
					totalFee = totalFee.add(countFee);
				}
			}
			
			if(type.equals("cku")){
				allCku = allCku.add(totalFee);
			}
			if(type.equals("cab")){
				allCab = allCab.add(totalFee);
			}
			
			totalData.put("name",name);
			totalData.put("totalFee",totalFee);
			totalData.put("items",chargeList);
			packageData.add(totalData);
			
		}
		return packageData;
	}
}