package com.cku.oa.dogsporting.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dogsporting.entity.DogSportingMembers;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.dogsporting.entity.DogSportingDogs;
import com.cku.oa.dogsporting.service.DogSportingDogsService;

import java.util.List;

/**
 * 犬运动犬只Controller
 *
 * @author yuanshuai
 * @version 2021-06-15
 */
@Controller
@RequestMapping(value = "${adminPath}/dogsporting/dog")
public class DogSportingDogsController extends BaseController {

	@Autowired
	private DogSportingDogsService dogSportingDogsService;


	@ModelAttribute
	public DogSportingDogs get(@RequestParam(required = false) String id) {
		DogSportingDogs entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogSportingDogsService.get(id);
		}
		if (entity == null) {
			entity = new DogSportingDogs();
		}
		return entity;
	}

	@RequiresPermissions("dogsporting:dog:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogSportingDogs dogSportingDogs, HttpServletRequest request, HttpServletResponse response, Model model,@ModelAttribute("errorMsg") String errorMsg) {
		Page<DogSportingDogs> page = dogSportingDogsService.findPage(new Page<>(request, response), dogSportingDogs);
		model.addAttribute("page", page);
		model.addAttribute("dogTypeList", dogSportingDogsService.getDogSportingDogTypeList());
		model.addAttribute("errorMsg", errorMsg);
		return "oa/dogsporting/dogSportingDogsList";
	}

	@RequiresPermissions("dogsporting:dog:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(DogSportingDogs dogSportingDogs, Model model) {
		model.addAttribute("dogTypeList", dogSportingDogsService.getDogSportingDogTypeList());
		model.addAttribute("dogSportingDogs", dogSportingDogs);
		model.addAttribute("isView", 1);
		return "oa/dogsporting/dogSportingDogsForm";
	}

	@RequiresPermissions("dogsporting:dog:edit")
	@RequestMapping(value = "editForm")
	public String form(DogSportingDogs dogSportingDogs, Model model) {
		model.addAttribute("dogTypeList", dogSportingDogsService.getDogSportingDogTypeList());
		model.addAttribute("dogSportingDogs", dogSportingDogs);
		model.addAttribute("isView", 0);
		return "oa/dogsporting/dogSportingDogsForm";
	}

	@RequiresPermissions("dogsporting:dog:edit")
	@PostMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(DogSportingDogs dogSportingDogs) {
		try {
			restBeanValidator(dogSportingDogs);
			dogSportingDogsService.save(dogSportingDogs);
		} catch (Exception ex) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return ResultDto.success(dogSportingDogs.getId());
	}

	/**
	 * 导入模板
	 *
	 * @author yuanshuai
	 * @date 2021/6/22 17:15
	 */
	@RequiresPermissions("dogsporting:dog:import")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			return dogSportingDogsService.importFileTemplate(response);
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("errorMsg", "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogsporting/dog/?repage";
	}

	/**
	 * 导入
	 *
	 * @author yuanshuai
	 * @date 2021/6/22 17:15
	 */
	@RequiresPermissions("dogsporting:dog:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			// 犬只信息导入
			dogSportingDogsService.importMember(file);
			addMessage(redirectAttributes, "导入犬只信息成功！");
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("errorMsg", "导入犬只信息失败！失败信息：##" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogsporting/dog/?repage";
	}

	/**
	 * 导出
	 * @author yuanshuai
	 * @date 2021/7/8 15:47
	 */
	@RequiresPermissions("dogsporting:dog:export")
	@RequestMapping(value = "export", method = RequestMethod.POST)
	public String export(DogSportingDogs dogSportingDogs, HttpServletRequest request, HttpServletResponse response,
						 RedirectAttributes redirectAttributes) throws Exception {
		List<DogSportingDogs> list;
		try {
			list = dogSportingDogsService.export(dogSportingDogs);
			// 导出
			new ExportExcel("犬运动犬只信息", DogSportingDogs.class, 2).setDataList(list).write(response, "犬运动犬只信息.xlsx").dispose();
		} catch (Exception e) {
			e.printStackTrace();
			redirectAttributes.addFlashAttribute("errorMsg", "导出犬只信息失败！失败信息：" + e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/dogsporting/member/?repage";
		}
		return null;
	}

	@RequiresPermissions("dogsporting:dog:print")
	@RequestMapping(value = "print")
	public String print(DogSportingDogs print, HttpServletRequest request, Model model) {
		DogSportingDogs dog =  dogSportingDogsService.updatePrintState(print.getId(),"1");
		model.addAttribute("dogSportingDogs", dog);
		return "oa/dogsporting/dogPrint";
	}

	@RequiresPermissions("dogsporting:dog:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogSportingDogs print) {
		dogSportingDogsService.updatePrintState(print.getId(),"0");
		return "redirect:" + Global.getAdminPath() + "/dogsporting/dog/?repage";
	}

}