package com.cku.oa.dog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.dog.entity.DogNoseCheckin;
import com.cku.oa.dog.service.DogNoseCheckinService;

/**
 * 鼻纹识别登记Controller
 * @author Sunny
 * @version 2021-04-14
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogNoseCheckin")
public class DogNoseCheckinController extends BaseController {

	@Autowired
	private DogNoseCheckinService dogNoseCheckinService;
	
	@ModelAttribute
	public DogNoseCheckin get(@RequestParam(required=false) String id) {
		DogNoseCheckin entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogNoseCheckinService.get(id);
		}
		if (entity == null){
			entity = new DogNoseCheckin();
		}
		return entity;
	}
	
	@RequiresPermissions("dog:dogNoseCheckin:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogNoseCheckin dogNoseCheckin, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogNoseCheckin> page = dogNoseCheckinService.findPage(new Page<DogNoseCheckin>(request, response), dogNoseCheckin); 
		model.addAttribute("page", page);
		return "oa/dog/dogNoseCheckinList";
	}

	@RequiresPermissions("dog:dogNoseCheckin:view")
	@RequestMapping(value = "form")
	public String form(DogNoseCheckin dogNoseCheckin, Model model) {
		model.addAttribute("dogNoseCheckin", dogNoseCheckin);
		return "oa/dog/dogNoseCheckinForm";
	}

	@RequiresPermissions("dog:dogNoseCheckin:edit")
	@RequestMapping(value = "save")
	public String save(DogNoseCheckin dogNoseCheckin, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogNoseCheckin)){
			return form(dogNoseCheckin, model);
		}
		dogNoseCheckinService.save(dogNoseCheckin);
		addMessage(redirectAttributes, "保存鼻纹识别登记成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogNoseCheckin/?repage";
	}
	
	@RequiresPermissions("dog:dogNoseCheckin:edit")
	@RequestMapping(value = "delete")
	public String delete(DogNoseCheckin dogNoseCheckin, RedirectAttributes redirectAttributes) {
		dogNoseCheckinService.delete(dogNoseCheckin);
		addMessage(redirectAttributes, "删除鼻纹识别登记成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogNoseCheckin/?repage";
	}

}