package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.vo.DogBloodSaveVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.finance.vo.PaymentOrderDetailQueryVO;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.service.AreaService;

/**
 * DNA血样留存Controller
 *
 * @author lgl
 * @version 2016-11-24
 */
@Controller
@RequestMapping(value = "${adminPath}/dogbloodsave/dogBloodSave")
public class DogBloodSaveController extends BaseController {

	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private AreaService areaService;
	@Autowired
	private OrgService orgService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath() + "/dogbloodsave/dogBloodSave/?repage";

	private final static String AUTHORITY_PRDFIX = "dogbloodsave:dogBloodSave:";

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogBloodSave", new DogBloodSave(runningNumber, chargingItemId, memberCode));
		model.addAttribute("provinceList", areaService.getProvince());
		return "oa/dog/dogbloodsave/dogBloodSaveOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogBloodSave dogBloodSave) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogBloodSaveService.add(dogBloodSave);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogBloodSave dogBloodSave, Model model) {
		List<DogBloodSave> list = dogBloodSaveService.findList(dogBloodSave);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService.getRefundStateForDogBloodSave(list.stream().map(
				a -> new PaymentOrderDetailQueryVO(a.getId(), a.getRunningNumber(), a.getFmdogBreedCertifiedCode()))
				.collect(Collectors.toList()));
		List<DogBloodSaveVO> list2 = list.stream().map(a -> {
			DogBloodSaveVO b = new DogBloodSaveVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId() + a.getRunningNumber())
					|| map.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/dogbloodsave/dogBloodSaveOrderList";
	}

	@RequestMapping(value = "getOrg")
	@ResponseBody
	public List<Org> getOrg(HttpServletRequest request) {
		String provinceName = request.getParameter("province");
		Org example = new Org();
		example.setAddress(provinceName);
		List<Org> list = orgService.findList(example);
		List<Org> result = list.stream().filter(a -> a.getOrgType().equals("hospital") || a.getOrgType().equals("club")
				|| a.getOrgType().equals("catRenZheng")).collect(Collectors.toList());
		return result;
	}

	@ModelAttribute
	public DogBloodSave get(@RequestParam(required = false) String id) {
		DogBloodSave entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogBloodSaveService.get(id);
		}
		if (entity == null) {
			entity = new DogBloodSave();
		}
		return entity;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogBloodSave dogBloodSave, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		if (request.getMethod().equals("GET")) {
			dogBloodSave.setBeginCreateDate(DateUtils.lastMonth(3));
		}
		Page<DogBloodSave> page = dogBloodSaveService.findPage1(new Page<DogBloodSave>(request, response),
				dogBloodSave);
		model.addAttribute("dogBloodSave", dogBloodSave);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService.getRefundStateForDogBloodSave(page.getList().stream().map(
				a -> new PaymentOrderDetailQueryVO(a.getId(), a.getRunningNumber(), a.getFmdogBreedCertifiedCode()))
				.collect(Collectors.toList()));
		List<DogBloodSave> list = page.getList().stream().map(a -> {
			DogBloodSaveVO b = new DogBloodSaveVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId() + a.getRunningNumber())
					|| map.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);

		return "oa/dog/dogbloodsave/dogBloodSaveList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogBloodSave dogBloodSave, Model model) {
		model.addAttribute("dogBloodSave", dogBloodSave);
		return "oa/dog/dogbloodsave/dogBloodSaveForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "save")
	public String save(DogBloodSave dogBloodSave, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogBloodSave)) {
			return form(dogBloodSave, model);
		}
		dogBloodSaveService.save(dogBloodSave);
		addMessage(redirectAttributes, "保存DNA血样留存成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogBloodSave dogBloodSave, RedirectAttributes redirectAttributes) {
		if ("2".equals(dogBloodSave.getPaymentState())) {
			addMessage(redirectAttributes, "该订单已缴费，不允许删除");
		} else {
			dogBloodSaveService.delete(dogBloodSave);
			addMessage(redirectAttributes, "删除DNA血样留存成功");
		}
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogBloodSave dogBloodSave, Model model) {
		return dogBloodSaveService.editForm(dogBloodSave, model);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	@ResponseBody
	public Object edit(DogBloodSave edit, Model model) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			DogBloodSave dogBloodSave = get(edit.getId());
			// 1有出生纸编号
			// 2初次录入DNA血样编号时标记为已采血
			if (StringUtils.isNotBlank(dogBloodSave.getBirthCode())
					&& StringUtils.isBlank(dogBloodSave.getBloodSampleCode())
					&& StringUtils.isNotBlank(edit.getBloodSampleCode())) {
				dogChipService.setBloodSaveFlag(dogBloodSave.getBirthCode());
			}
			dogBloodSave.setBloodSampleCode(edit.getBloodSampleCode());
			dogBloodSaveService.save(dogBloodSave);
			// TODO 财务收入确认时点
			saPaymentDetailTotalService.financeConfirmTime(dogBloodSave.getId(), "dog_blood_save");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
			if (e instanceof org.springframework.dao.DuplicateKeyException) {
				map.put("msg", "该DNA血样编号在数据库中已存在");
			}
		}
		return map;
	}
	
	
	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "cancel")
	public String cancel(DogBloodSave dogBloodSave, RedirectAttributes redirectAttributes) {
		dogBloodSaveService.cancel(dogBloodSave);
		addMessage(redirectAttributes, "撤销DNA血样留存成功");
		return REPAGE;
	}

}