/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.restful.v1.dog.model.RestDogColorMark;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 犬只颜色及标志Service
 * 
 * @author lgl
 * @version 2016-08-05
 */
@Service
@Transactional(readOnly = true)
public class DogColorMarkService extends CrudService<DogColorMarkDao, DogColorMark> {

	@Autowired
	private DogTypeService dogTypeService;
	
	

	// public DogColorMark get(String id) {
	// return super.get(id);
	// }
	//
	// public List<DogColorMark> findList(DogColorMark dogColorMark) {
	// return super.findList(dogColorMark);
	// }
	//
	// public Page<DogColorMark> findPage(Page<DogColorMark> page, DogColorMark
	// dogColorMark) {
	// return super.findPage(page, dogColorMark);
	// }
	//
	// @Transactional(readOnly = false)
	// public void save(DogColorMark dogColorMark) {
	// super.save(dogColorMark);
	// }
	//
	// @Transactional(readOnly = false)
	// public void delete(DogColorMark dogColorMark) {
	// super.delete(dogColorMark);
	// }

	public List<DogColorMark> findAllList() {
		return dao.findAllList(new DogColorMark());
	}

	public DogColorMark getByDogColorMarkCode(String dogColorMarkCode) {
		return dao.getByDogColorMarkCode(dogColorMarkCode);
	}

	/**
	 * 
	 * @description: 根据犬种获取毛色列表
	 * @author: laiguanglong
	 * @date: 2016年9月7日 下午5:07:07
	 */
	public List<DogColorMark> getByDogBreedCode(String dogBreedCode) {
		List<DogColorMark> list = dao.findAllList(new DogColorMark());
		List<DogColorMark> dogColorMarkList = new ArrayList<DogColorMark>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogBreedCode);
		if (dogType != null && StringUtils.isNotBlank(dogType.getDogColor())) {
			for (String dogColor : dogType.getDogColor().split(",")) {
				DogColorMark dogColorMark = getByDogColorMarkCode(dogColor);
				if (dogColorMark != null) {
					dogColorMarkList.add(dogColorMark);
				}
			}
			return dogColorMarkList;
		} else {
			return list;
		}

	}
	
	public List<RestDogColorMark> getDogColor(String dogBreedCode) {
		List<RestDogColorMark> list = new ArrayList<RestDogColorMark>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogBreedCode);
		if(StringUtils.isEmpty(dogType.getDogColor())) {
			List<DogColorMark> colors =  dao.findList(new DogColorMark());
			for(DogColorMark m : colors) {
				RestDogColorMark vo = new RestDogColorMark();
				BeanUtil.copyProperties(vo, m, "yyyy-MM-dd");
				list.add(vo);
			}
		}else {
			for (String dogColor : dogType.getDogColor().split(",")) {
				DogColorMark dogColorMark = dao.getByDogColorMarkCode(dogColor);
				if (dogColorMark != null) {
					RestDogColorMark vo = new RestDogColorMark();
					BeanUtil.copyProperties(vo, dogColorMark, "yyyy-MM-dd");
					list.add(vo);
				}
			}
		}
		return list;
	}


	
	
	/**
	 * @description: 根据毛色代码获取毛色中文名
	 * @author: laiguanglong
	 * @date: 2017/10/10 17:04
	 */
	public String getDogColorMarkCn(String dogColorMarkCode) {
		String dogColorMarkCn = "";
		DogColorMark dogColorMark = dao.getByDogColorMarkCode(dogColorMarkCode);
		if (dogColorMark != null) {
			dogColorMarkCn = dogColorMark.getDogColorMarkCn();
		}
		return dogColorMarkCn;
	}

	public String getDogColorMarkCnSimple(String dogColorMarkCode) {
		String dogColorMarkCn = "";
		DogColorMark dogColorMark = dao.getDogColorMarkCnSimple(dogColorMarkCode);
		if (dogColorMark != null) {
			dogColorMarkCn = dogColorMark.getDogColorMarkCn();
		}
		return dogColorMarkCn;
	}
}