/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogDnaArchiveReissueSampling;
import com.cku.oa.sampling.entity.Sampling;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬只DNA存档采样包补寄DAO接口
 * 
 * @author Sunny
 * @version 2023-06-29
 */
@MyBatisDao
public interface DogDnaArchiveReissueSamplingDao extends CrudDao<DogDnaArchiveReissueSampling> {

	List<Sampling> findReissueSamplingRecordByDnaArchiveId(@Param("dnaArchiveId") String dnaArchiveId);
	
	List<DogDnaArchiveReissueSampling> findByRunningNumber(@Param("runningNumber") String runningNumber);

}