/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.apidoc.entity;

import org.hibernate.validator.constraints.Length;
import com.fasterxml.jackson.annotation.JsonBackReference;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 接口分类Entity
 * @author fanhuibin
 * @version 2016-09-06
 */
public class ApiCategory extends DataEntity<ApiCategory> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 分类名
	private ApiCategory parent;		// 父id
	private String order;		// 排序字段
	
	public ApiCategory() {
		super();
	}

	public ApiCategory(String id){
		super(id);
	}

	@Length(min=1, max=200, message="分类名长度必须介于 1 和 200 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@JsonBackReference
	public ApiCategory getParent() {
		return parent;
	}

	public void setParent(ApiCategory parent) {
		this.parent = parent;
	}
	
	@Length(min=0, max=11, message="排序字段长度必须介于 0 和 11 之间")
	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}
	
}