//商城购物车
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //购物车中商品列表
        me.shopGoodList = ko.observableArray([]);
        //展现的数量和价格
        me.showNum = ko.observable("0");
        me.showTotal = ko.observable("0");
        me.allNum = ko.observable("0");
        me.addTotal = ko.observable("0");
        me.member = ko.observable({});
        //购物车id，以逗号分隔
        me.shopCartsId = ko.observableArray([]);
        //邮寄方式:到付快递0;平邮1;协会自取2
        //me.postType = ko.observable("0");
        me.postType = ko.observable("");
        //收货省份
        me.province = ko.observable("");
        //收货城市
        me.city = ko.observable("");
        //收货地址
        me.address = ko.observable("");
        //收货电话
        me.postDel = ko.observable("");
        //收货人姓名
        me.postName = ko.observable("");
        //邮编
        me.postCode = ko.observable("");
        //买家留言
        me.message = ko.observable("");

        //省List
        me.provinceList = ko.observableArray([]);
        //市List
        me.cityList = ko.observableArray([]);
        me.provinceHtml = ko.observable("");
        me.cityHtml = ko.observable("");
        me.showProvince = function(){
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{
                $("#provinceDiv").css("display","none");
            }
            $("#cityDiv").css("display","none");
        }
        me.showCity = function(){
            if($("#cityDiv").css("display")=="none"){
                $("#cityDiv").css("display","block");
            }else{
                $("#cityDiv").css("display","none");
            }
            $("#provinceDiv").css("display","none");
        }
        me.changeProvince = function(data){
            me.provinceHtml(data);
            me.province(data);
            for(var i = 0;i<util.city.length;i++){
                if(data==util.city[i].local){
                    me.initProCity(data,util.city[i].localcity[0]);
                }
            }
            $("#provinceDiv").css("display","none");
        }
        me.changeCity = function(data){
            me.city(data);
            me.cityHtml(data);
            $("#cityDiv").css("display","none");
        }
        me.initProCity = function(province,city){
            me.provinceList().length = 0;
            me.cityList().length = 0;
            me.provinceHtml(province);
            me.cityHtml(city);
            for(var i = 0;i<util.city.length;i++){
                me.provinceList.push(util.city[i].local);
                if(province==util.city[i].local){
                    for(var j=0;j<util.city[i].localcity.length;j++){
                        me.cityList.push(util.city[i].localcity[j]);
                    }
                }
            }
        }
        /**
         * 查询购物车
         */
        me.findShopCartsList = function(){
            util.sendAjax({
                url:'shop/shopCarts',
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            me.shopCartsId.removeAll();
                            var goodList = json.list;
                            me.shopGoodList(goodList);
                            var num = 0;
                            var total = 0;
                            for(var i=0;i<goodList.length;i++){
                                num+=parseInt(goodList[i].goodsNum);
                                total+=parseFloat(goodList[i].totalPrice);
                                if(goodList[i].isBuyGifts=="0"){
                                    me.shopCartsId.push(goodList[i].id);
                                }
                            }
                            me.showNum(num);
                            me.showTotal(total.toFixed(2));
                            me.allNum(num);
                            me.addTotal(total.toFixed(2));
                        }else{
                            me.shopGoodList([]);
                            me.showNum("0");
                            me.showTotal("0");
                            layer.msg("购物车列表数据为空！");
                        }
                    }else{
                        layer.msg("查询购物车失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //me.changePostType = function(id){
        //    me.postType(id);
        //    $("#postType0").removeClass("checked");
        //    $("#postType1").removeClass("checked");
        //    $("#postType2").removeClass("checked");
        //    $("#postType"+id).addClass("checked");
        //}
        /**
         * 提交订单
         */
        me.saveOrder = function(){
            var sendData = {};

            if(me.shopCartsId().length==0){
                layer.msg("请选择购物车中的商品！");
                return;
            }
            if(util.isVal(me.address())==""){
                layer.msg("收货地址不能为空！");
                return;
            }
            if(util.isVal(me.postCode())==""){
                layer.msg("收货邮编不能为空！");
                return;
            }
            if(!util.isMobile(me.postDel())){
                layer.msg("联系电话不正确！");
                return;
            }
            if(util.isVal(me.postName())==""){
                layer.msg("收件人不能为空！");
                return;
            }

            sendData["shopCartsId"] = me.shopCartsId().join(",");
            sendData["postType"] = me.postType();
            sendData["province"] = me.province();
            sendData["city"] = me.city();
            sendData["address"] = me.address();
            sendData["postDel"] = me.postDel();
            sendData["postName"] = me.postName();
            sendData["postCode"] = me.postCode();
            sendData["message"] = me.message();
            util.sendAjax({
                url:'shop/shopOrder',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeShopCart();
                        location.href = location.href.split("#")[0]+"#/payment/payment?id="+json.data.id+"&type=shop";
                    }else{
                        layer.msg("提交订单失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //减商品
        me.subtractGoods = function(data){
            util.sendAjax({
                url:'shop/shopCarts/subtractGoods/'+data.id,
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("减少商品成功！");
                        context.app.changeShopCart();
                        me.findShopCartsList();
                    }else{
                        layer.msg("减少商品失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        //加商品
        me.addGoods = function(data){
            util.sendAjax({
                url:'shop/shopCarts/addGoods/'+data.id,
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("添加商品成功！");
                        context.app.changeShopCart();
                        me.findShopCartsList();
                    }else{
                        layer.msg("添加商品失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        /**
         * 删除购物车中商品
         * @param id
         */
        me.delGoods = function(data){
            var delGoodsLayer = layer.confirm('您确认删除此商品？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                util.sendAjax({
                    url:'shop/shopCarts/'+data.id,
                    data:{},
                    async:true,
                    loadFlag:true,
                    type:'DELETE',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            context.app.changeShopCart();
                            me.findShopCartsList();
                            layer.close(delGoodsLayer);
                        }else{
                            layer.msg("删除商品失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                        }
                    }
                });
            }, function(){
            });
        }
        /**
         * 全选按钮
         */
        me.selectAll = function(){
            if($("#radioParent").hasClass("checked")){
                $("#radioParent").attr("class","checkbox");
                $("table tbody tr td a[name='radioa']").attr("class","checkbox");
                me.shopCartsId([]);
                me.showNum("0");
                me.showTotal("0");
            }else{
                $("#radioParent").attr("class","checkbox checked");
                $("table tbody tr td a[name='radioa']").attr("class","checkbox checked");
                var arr = [];
                $.each(me.shopGoodList(),function(index,item){
                    if(item.isBuyGifts=="0"){
                        arr.push(item.id);
                    }
                })
                me.shopCartsId(arr);
                me.showNum(me.allNum());
                me.showTotal(me.addTotal());
            }
        }
        /**
         * 单选按钮
         * @param data
         */
        me.selectOne = function(data){
            if($("#radio"+data.id).hasClass("checked")){
                $("#radio"+data.id).attr("class","checkbox");
                $("#radioParent").attr("class","checkbox");
                me.shopCartsId.remove(data.id);
                me.showNum(parseInt(me.showNum())-parseInt(data.goodsNum));
                me.showTotal((parseFloat(me.showTotal())-parseFloat(data.totalPrice)).toFixed(2));
            }else{
                $("#radio"+data.id).attr("class","checkbox checked");
                var allCheck = true;
                var objs = $("table tbody tr td a[name='radioa']");
                $.each(objs,function(index,item){
                    if(!$("#"+item.id).hasClass("checked")){
                        allCheck = false;
                    }
                });
                me.shopCartsId.push(data.id);
                me.showNum(parseInt(me.showNum())+parseInt(data.goodsNum));
                me.showTotal((parseFloat(me.showTotal())+parseFloat(data.totalPrice)).toFixed(2));
                if(allCheck){
                    $("#radioParent").attr("class","checkbox checked");
                }
            }
        };
        $(function(){
            me.findShopCartsList();
            me.member(userInfo.getMember());
            me.province(me.member().province);
            me.city(me.member().city);
            me.address(me.member().street);
            me.postCode(me.member().postcode);
            me.postDel(me.member().mobile);
            me.postName(me.member().name);
            me.initProCity(me.province(),me.city());
        })
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(true);
    }
});