//配种证明列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //当前登陆人信息；
        var member = userInfo.getMember();
        me.member = ko.observable(member);
        var kennel = userInfo.getKennel();
        me.kennel = ko.observable(kennel);
        //列表数据
        me.listData = ko.observableArray([]);
        //配种证明编号
        me.breedCertifiedCode = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddognewbornList(false);
        }
        
        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddognewbornList(false);
        }
        
        me.pageAction = function(data){
        	if(data.pageNo == -1){
        		//什么都不做
        	}else if(me.pageNo() == data.pageNo){
        		//alert("当前选中的就是该页");
                me.finddognewbornList(false);
        	}else{
        		//alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddognewbornList(false);
        	}
        	return false;
        }
        //未通过原因的显示隐藏
        me.showReason = function(data,event){
            if(data.reviewState=="不通过"){
                if($(event.target).parent("a").siblings(".reason").css("display")=="none"){
                    $(event.target).parent("a").siblings(".reason").css("display","block");
                }else{
                    $(event.target).parent("a").siblings(".reason").css("display","none");
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none");
        }
        //未通过原因的显示隐藏
        me.showSemenCode = function(data,event){
    		if($(event.target).parent("a").siblings(".reason").css("display")=="none"){
    			$(event.target).parent("a").siblings(".reason").css("display","block");
    		}else{
    			$(event.target).parent("a").siblings(".reason").css("display","none");
    		}
        }
        me.closeSemenCode = function(data,event){
        	$(event.target).parents(".reason").css("display","none");
        }
        /**
         * 配种证明列表查询方法
         */
        me.finddognewbornList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["breedCertifiedCode"] = me.breedCertifiedCode().trim();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'dog/dognewborn',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            $.each(data.list,function(index,item){
                                var memberCode = me.member().memberCode;
                                //母犬犬主会员号
                                var fdogOwnerCode = item.fdogOwnerCode;
                                //公犬犬主会员号
                                var mdogOwnerCode = item.mdogOwnerCode;
                                if((item.reviewState=="不通过"|| item.reviewState=='未审核') && item.canEdit){
                                    if( mdogOwnerCode==memberCode){
                                        item["manage"]="修改";
                                        item["manage2"]="";
                                        item["manageClass"] = "repeal";
                                    }else{
                                        item["manage"]="";
                                        item["manage2"]="";
                                        item["manageClass"] = "";
                                    }
                                }else if(item.reviewState=="通过"){
                                    if(memberCode==fdogOwnerCode){
                                        if(item.isHaveDogBirthCertificate=="0"){
                                            item["manage"]="申请登记卡";
                                            item["manage2"]="证书申请(整窝)";
                                            item["manageClass"] = "pending";
                                        }else{
                                            item["manage"]="申请登记卡";
                                            item["manage2"]="证书申请(整窝)";
                                            item["manageClass"] = "gray";
                                        }
                                     }else{
                                        item["manage"]="";
                                        item["manage2"]="";
                                        item["manageClass"] = "gray";
                                    };
                                }else if(item.reviewState=="已注销"){
                                	item["manage"]="已注销";
                                    item["manage2"]="";
                                    item["manageClass"] = "gray";
                                }else{
                                	item["manage"]="";
                                    item["manage2"]="";
                                    item["manageClass"] = "gray";
                                }
                            });
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("配种证明列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //申请出生纸 跳转
        me.sendMsg = function(data,num,event){
        	if(me.member().memberType=='professional'){
        		var  memberEndTime = new Date(new Date(util.formatDateLong(me.member().memberEndDate).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime();
        		var kennelEndTime  = new Date(new Date(util.formatDateLong(me.kennel().endTime).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime();
        		if(memberEndTime>=0&&kennelEndTime>=0){
        			var memberCode = me.member().memberCode;
        			var fdogOwnerCode = data.fdogOwnerCode;
        			if(data.isHaveDogBirthCertificate!="1"){
        				if(memberCode==fdogOwnerCode){
        					var id = data.id;
        					if(num == 1){
                                location.href = location.href.split("#")[0]+"#/dog/birthcertificateapply?id="+id;
                            }else if(num == 2){
                                location.href = location.href.split("#")[0]+"#/dog/newdogchipaddtotal?id="+id;
                            }
        				}
        			}
        		}else{
        			layer.msg("该业务仅限有效专业会员及犬舍办理!");
        		}
        	}else{
        		layer.msg("该业务仅限有效专业会员及犬舍办理!");
        	}
        }
        //修改 跳转
        me.amend = function(num,data,event){
        	if (userInfo.getMember().memberType== "basic") {
                me.isbd(false);
            } else {
                var memberCode = me.member().memberCode;
                if(data.reviewState=="不通过"|| data.reviewState=='未审核'){
                	if( data.mdogOwnerCode==memberCode){
                		var malePedigreeCertified = data.malePedigreeCertified;
                		var femalePedigreeCertified = data.femalePedigreeCertified;
                		var urgent = data.urgent;
                		var breedDate = data.breedDate;
                		var id = data.id;
                		var semenCode = data.semenCode;
                		if(semenCode==''){
                			location.href = location.href.split("#")[0]+"#/dog/dognewbornadd?malePedigreeCertified="+malePedigreeCertified+"&femalePedigreeCertified="+femalePedigreeCertified+"&urgent="+urgent+"&breedDate="+breedDate+"&id="+id;
                		}else{
                			location.href = location.href.split("#")[0]+"#/dog/dognewbornsemenadd?malePedigreeCertified="+malePedigreeCertified+"&femalePedigreeCertified="+femalePedigreeCertified+"&urgent="+urgent+"&breedDate="+breedDate+"&id="+id+"&semenCode="+semenCode;
                		}
                	}
                }else if(data.reviewState=="通过"){
                	util.sendAjax({
                		url:'dog/dognewborn/'+data.id,
                		data:{},
                		async:true,
                		loadFlag:true,
                		type:'GET',
                		cache:false,
                		success:function(json){
                			if(json.rc==0){
                				if(memberCode==data.fdogOwnerCode){
                					if(data.isHaveDogBirthCertificate=="0"){
                						me.sendMsg(data,num);
                					}
                				};
                			}else{
                				layer.msg("信息获取失败:"+json.msg);
                			}
                		}
                	});
                }
            }
        }
        $(function(){
            me.finddognewbornList(false);
        });
        me.isbd = ko.observable(true);//默认不显示
        //配种证明申请区分专业会员和普通会员
        me.addDognewborn = function () {
            if (userInfo.getMember().memberType== "basic") {
                me.isbd(false);
            } else {
                window.location.href = "#/dog/dognewbornadd";
            }
        }
      //点击升级会员/暂不升级退出事件
        me.changeTopNav = function(type) {
            if (type == "no") {//退出
                me.isbd(true);
            } else if (type == 'bd') {//升级
            	util.sendAjax({
                    url: 'member/upgrade',
                    data: {},
                    async: false,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("会员升级失败,错误代码:" + json.rc + "错误信息:" + json.msg);
                        }
                    }
                });
            }
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});