//牵犬师申请结业证明 资料提交
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.member = ko.observable({});
        //结业证书列表
        me.handlerDiplomaList = ko.observableArray([]);
        //身份证号
        me.card_no = ko.observable("");
        //会员号
        me.memberCode = ko.observable("");
        //注册会员信息的显隐 默认隐
        me.isShowMsg = ko.observable(false);
        //会员注册信息
        //身份证号
        me.newCard_no = ko.observable("");
        //固定电话
        me.mobile = ko.observable("");
        //美容备注
        me.groomer_remarks = ko.observable("");
        //缴费详情
        me.payment_info = ko.observable("");
        //邮编
        me.postcode = ko.observable("");
        //姓名
        me.name = ko.observable("");
        //城市
        me.city = ko.observable("");
        //邮箱
        me.email = ko.observable("");
        //传真电话
        me.fax = ko.observable("");
        //省
        me.province = ko.observable("");
        //街道
        me.street = ko.observable("");
        //移动电话
        me.phone = ko.observable("");
        //qq
        me.qq = ko.observable("");
        //性别
        me.gender = ko.observable("");
        //生日
        me.birthday = ko.observable("");
        //省List
        me.provinceList = ko.observableArray([]);
        //市List
        me.cityList = ko.observableArray([]);
        me.provinceHtml = ko.observable("");
        me.cityHtml = ko.observable("");
        //开始日期，格式"2016-11-11"
        me.startDate = ko.observable("");
        //	结束日期，格式"2016-12-12"
        me.endDate = ko.observable("");
        //培训教师
        me.teacher = ko.observable("");
        //级别:A;B;C
        me.certificateLevel = ko.observable("");
        //培训类型
        me.handlerType = ko.observable("0");
        //选择的级别
        me.certificateLevelText = ko.observable("请选择");
        //级别下拉框的显隐 默认隐
        me.isShowLevel= ko.observable(false);
        //级别下拉框的显隐
        me.showLevel = function(){
            me.isShowLevel(!me.isShowLevel());
        }
        //注册会员 显示隐藏
        me.showMsg = function(){
            me.isShowMsg(!me.isShowMsg());
        }
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.getHandlerDiplomaList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.getHandlerDiplomaList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.getHandlerDiplomaList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.getHandlerDiplomaList(false);
            }
            return false;
        }
        //查询是否为会员
        me.searchMember = function(){
            if(me.card_no()!=""&&me.card_no().length>0){
                var sendData = {};
                sendData["card_no"] = me.card_no();
                util.sendAjax({
                    url:'member/searchMemberByCardNo',
                    data:sendData,
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(data){
                        if(data.rc==0){
                            if(data.data.isValid=="0"){
                                layer.msg("您还不是会员，请注册")
                            }else{
                                layer.msg("会员存在");
                                me.memberCode(data.data.memberCode);
                            }
                        }
                    }
                });
            }
        }
        //选择性别
        me.chooseGender = function(type){
            $("#gender a").removeAttr("class");
            $("#"+type).attr("class","checked");
            me.gender(type);
        }
        //联系地址的选择
        me.showProvince = function(){
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{
                $("#provinceDiv").css("display","none");
            }
        }

        me.showCity = function(){
            if($("#cityDiv").css("display")=="none"){
                $("#cityDiv").css("display","block");
            }else{
                $("#cityDiv").css("display","none");
            }
        }

        me.changeProvince = function(data){
            me.member().province = data;
            me.provinceHtml(data);
            me.province(data);
            for(var i = 0;i<util.city.length;i++){
                if(data==util.city[i].local){
                    me.initProCity(data,util.city[i].localcity[0]);
                }
            }
            $("#provinceDiv").css("display","none");
        }
        me.changeCity = function(data){
            me.member().city = data;
            me.cityHtml(data);
            me.city(data);
            $("#cityDiv").css("display","none");
        }

        me.initProCity = function(province,city){
            me.provinceList().length = 0;
            me.cityList().length = 0;
            me.provinceHtml(province);
            me.cityHtml(city);
            for(var i = 0;i<util.city.length;i++){
                me.provinceList.push(util.city[i].local);
                if(me.member().province==util.city[i].local){
                    for(var j=0;j<util.city[i].localcity.length;j++){
                        me.cityList.push(util.city[i].localcity[j]);
                    }
                }
            }
        }
        /**
         * 注册会员
         * @param type
         */
        me.applyMember = function(){
            var sendData = {};
            sendData["cardNo"] = me.newCard_no();
            //固定电话
            sendData["mobile"] = me.mobile();
            //美容备注
            sendData["groomerRemarks"] = me.groomer_remarks();
            //缴费详情
            sendData["paymentInfo"] = me.payment_info();
            //邮编
            sendData["postcode"] = me.postcode();
            //姓名
            sendData["name"] = me.name();
            //城市
            sendData["city"] = me.city();
            //邮箱
            sendData["email"] = me.email();
            //传真电话
            sendData["fax"] = me.fax();
            //省
            sendData["province"] = me.province();
            //街道
            sendData["street"] = me.street();
            //移动电话
            sendData["phone"] = me.phone();
            //qq
            sendData["qq"] = me.qq();
            //生日
            sendData["birthday"] = $("#birthday").val();
            //性别
            sendData["gender"] = me.gender();
            util.sendAjax({
                url:'member/save',
                data: JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("注册会员成功");
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        //选择级别
        me.chooseLevel = function(type){
            $("#allLevel dd").removeAttr("class");
            $("#level"+type).parent("dd").attr("class","active");
            var level = $("#level"+type).text();
            if(type!="T"){
                me.certificateLevel("牵犬师"+type+"级");
            }else{
                me.certificateLevel("精英培训班");
            }
            me.certificateLevelText(level);
            me.isShowLevel(!me.isShowLevel());
        }
        /**
         * 牵犬师结业证书录入申请
         */
        me.applyHandlerDiploma = function(){
            var sendData = {};
            sendData["memberCode"] = me.memberCode();
            sendData["startDate"] = $("#startDate").val();
            sendData["endDate"] = $("#endDate").val();
            sendData["teacher"] = me.teacher();
            sendData["certificateLevel"] = me.certificateLevel();
            sendData["handlerType"] = me.handlerType();
            util.sendAjax({
                url:'handler/handlerDiploma',
                data: JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("添加购物车成功！");
                        context.app.changeCart();
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        /**
         * 获取结业证书列表页
         */
        me.getHandlerDiplomaList = function(){
            var sendData = {};
            sendData["paymentState"] = "1";
            sendData["handlerType"] = "0";
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'handler/getHandlerDiplomaList',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.handlerDiplomaList(data.list);
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }else{
                        layer.msg(data.msg);
                    }
                }
            });
        }
        //批量提交的选择
        me.chooseSub = function(data,event){
            if($(event.target).hasClass("radio")){
                $(event.target).removeClass("radio");
                $(event.target).addClass("checked");
            }else{
                $(event.target).removeClass("checked");
                $(event.target).addClass("radio");
            }
        }
        //批量单个提交
        me.personApplyHandlerDiploma = function(data,event){
            var sendData = {};
            sendData["memberCode"] = data.memberCode;
            sendData["startDate"] = data.startDate;
            sendData["endDate"] = data.endDate
            sendData["teacher"] = data.teacher;
            sendData["certificateLevel"] = data.certificateLevel;
            util.sendAjax({
                url:'groomer/groomerDiploma',
                data: JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("添加购物车成功！");
                        context.app.changeCart();
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        //批量单个删除
        me.delPersonApply = function(data,event){
            var id = data.id;
            util.sendAjax({
                url:'groomer/groomerDiploma/'+id,
                data:{},
                async:false,
                type:'DELETE',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        window.location.reload();
                    }else{
                        layer.msg(data.msg);
                    }
                }
            });
        }
        $(function(){
            /**
             * 初始化个人信息
             */
            me.member(userInfo.getMember());
            me.initProCity(me.member().province,me.member().city);
            me.getHandlerDiplomaList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
