//会员信息完善页面
define(["knockout"],function(ko){
    return function(context){
    	var me = this;
    	var checkAgreement = false;
		me.provinceHtml = ko.observable("请选择省份");
		me.cityHtml = ko.observable("请选择城市");
		me.areaHtml = ko.observable("请选择区域");
		me.name = ko.observable("");
    	me.code = ko.observable("");
    	me.province = ko.observable("");
		me.provinceCode = ko.observable("");
    	me.city = ko.observable("");
		me.cityCode = ko.observable("");
		me.area = ko.observable("");
		me.areaCode = ko.observable("");
    	me.address = ko.observable("");
    	me.sendType = ko.observable("到付快递");
		//省List
		me.provinceList = ko.observableArray([{name:'',code:''}]);
		//市List
		me.cityList = ko.observableArray([{name:'',code:''}]);
		//区域
		me.areaList = ko.observableArray([{name:'',code:''}]);
    	me.chooseBasic = function(){
    		$("#basic").removeClass();
    		$("#basic").addClass("menberbox fl active");
    		$("#professional").removeClass();
    		$("#professional").addClass("menberbox fr");
    		$("#memberType").val("basic");
    	}
    	me.chooseProfessional = function(){
    		$("#professional").removeClass();
    		$("#professional").addClass("menberbox fr active");
    		$("#basic").removeClass();
    		$("#basic").addClass("menberbox fl");
    		$("#memberType").val("professional");
	    }
    	me.showSendType = function(){
    		if($("#sendType").css("display")=="none"){
                $("#sendType").css("display","block");
            }else{
                $("#sendType").css("display","none");
            }
    	}
    	me.showProvince = function(){
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{
                $("#provinceDiv").css("display","none");
            }
            $("#cityDiv").css("display","none");
        }
    	me.showCity = function(){
            if($("#cityDiv").css("display")=="none"){
                $("#cityDiv").css("display","block");
            }else{
                $("#cityDiv").css("display","none");
            }
            $("#provinceDiv").css("display","none");
        }
		me.showArea = function(){
			if($("#areaDiv").css("display")=="none"){
				$("#areaDiv").css("display","block");
			}else{
				$("#areaDiv").css("display","none");
			}
			$("#provinceDiv").css("display","none");
			$("#cityDiv").css("display","none");
		}
		me.changeProvince = function(data){
			me.provinceHtml(data.name);
			me.provinceCode(data.code);
			me.cityList([]);
			me.cityCode("");
			me.cityHtml("请选择城市");
			me.areaList([]);
			me.areaCode("");
			me.areaHtml("请选择区域");
			//获取城市
			$.ajax({
				url:'https://vip.chongaibao.com/caibmobile/sys-api/city/list.do',
				data: {province_code:me.provinceCode()},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							me.cityList.push({name:lists[i].city,code:lists[i].cityId});
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
			$("#provinceDiv").css("display","none");
		}
		me.changeCity = function(data){
			me.cityHtml(data.name);
			me.cityCode(data.code);
			$("#cityDiv").css("display","none");
			me.areaList([]);
			me.areaCode("");
			me.areaHtml("请选择区域")
			$.ajax({
				url:'https://vip.chongaibao.com/caibmobile/sys-api/area/list.do',
				data: {city_code:me.cityCode()},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								me.areaList.push({name:lists[i].area,code:lists[i].areaId});
							}
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
		}
		me.changeArea = function(data){
			me.areaHtml(data.name);
			me.areaCode(data.code);
			$("#areaDiv").css("display","none");
		}
    	me.check = function(){
    		if($("#checkAgreement").attr('class')=='radio checked'){
    			$("#checkAgreement").removeClass();
    			$("#checkAgreement").addClass('radio');
    			checkAgreement = true;
    		} else if($("#checkAgreement").attr('class')=='radio'){
    			$("#checkAgreement").removeClass();
    			$("#checkAgreement").addClass('radio checked');
    			checkAgreement = false;
    		}
    	}
    	me.submit = function(){
    		if(util.isVal(me.name())==""){
    			layer.msg("请填写姓名");
    			return;
    		}
    		if(util.isVal(me.code())==""){
    			layer.msg("请填写身份证号");
    			return;
    		} else if(!util.isCardNo(me.code())){
    			layer.msg("身份证号格式不正确");
    			return;
    		}
			if(util.isVal(me.provinceCode())==""){
				layer.msg("请填写省份");
				return;
			}
			if(util.isVal(me.cityCode())==""){
				layer.msg("请填写城市");
				return;
			}
			if(util.isVal(me.areaCode())==""){
				layer.msg("请填写区域");
				return;
			}
			if(util.isVal(me.address())==""){
				layer.msg("请填写详细地址");
				return;
			}
    		if(checkAgreement){
    			var sendData = {};
                sendData["realName"] = me.name();
                sendData["idCard"] = me.code();
    			util.sendAjax({
                    url:'open/getSessionMobile',
                    data:JSON.stringify(sendData),
                    async:true,
                    loadFlag:true,
                    type:'POST',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                        	$("#confimPhone").html(json.data.mobile);
                        	if($("#memberType").val()=='basic'){
                    			$("#cofimType").html("基础会员");
                    		} else if($("#memberType").val()=='professional'){
                    			$("#cofimType").html("专业会员");
                    		}
                    		$("#confimName").html(me.name());
                    		$("#confimCode").html(me.code());
                    		$("#confimPost").html(me.sendType());
							$("#confimAddress").html(me.provinceHtml()+me.cityHtml()+me.areaHtml()+me.address());
                    		$("#confimMessage").show();
                        }else{
                            layer.msg("错误编码:"+json.rc+"错误信息:"+json.msg);
                        }
                    }
                });
    		} else {
    			layer.msg("请阅读并同意《CKU注册协议》");
    		}
    	}
    	me.returnData = function(){
    		$("#confimMessage").hide();
    	}
    	me.changeSendType = function(data){
    		me.sendType(data);
    		$("#sendType").css("display","none");
    	}
    	me.submitAll = function(){
    		var sendData = {};
            sendData["mobile"] = $("#confimPhone").html();
            sendData["newPassword"] = "123456";
            sendData["name"] = $("#confimPhone").html();
            sendData["loginName"] = $("#confimPhone").html();
            //会员类型
            sendData["memberType"] = $("#memberType").val();
            //姓名
            sendData["realName"] = me.name();
            //身份证号
            sendData["cardNo"] = me.code();
            //手机号
            sendData["phone"] = $("#confimPhone").html();
            //邮寄方式
            sendData["deliveryCertified"] = me.sendType();
            sendData["province"] = me.provinceHtml();
            sendData["city"] = me.cityHtml();
			sendData["area"] = me.areaHtml();
            sendData["street"] = me.address();
            util.sendAjax({
                url:'open/newRegister',
                data:JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("注册成功！");
                        window.location.href="#/login/success";
                    }else{
                        layer.msg("注册失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }

                }
            });
    	}
    	$(function(){
			//省份初始化
			me.provinceList([]);
			me.provinceCode("");
			me.provinceHtml("请选择省份");
			me.cityList([]);
			me.cityCode("");
			me.cityHtml("请选择城市")
			$.ajax({
				url:'https://vip.chongaibao.com/caibmobile/sys-api/province/list.do',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							me.provinceList.push({name:lists[i].province,code:lists[i].provinceId});
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
    	})
    	context.app.loading(false);
    }
});