define(["knockout"], function(ko) {
  return function(context) {
    var renew = this;
    renew.data = ko.observable({
      kennel: { name: "", nameEn: "" },
      member: {}
    });
    renew.samePeriodRenewType = ko.observable("1");
    renew.samePeriodRenewTypeUrl = ko.observable("0");
    renew.kennelNameShow = ko.observable("");
    renew.kennelNameCheckFlag = ko.observable(false);
    renew.isNameError = ko.observable(false);

    renew.kennelNameEnShow = ko.observable("");
    renew.kennelNameEnCheckFlag = ko.observable(false);
    renew.isNameEnError = ko.observable(false);

    //是否已读
    renew.isCheck = ko.observable("0");

    renew.renewal = function() {
      util.sendAjax({
        url:
          "member/renewal?samePeriodRenewType=" + renew.samePeriodRenewType(),
        async: true,
        loadFlag: true,
        type: "GET",
        cache: false,
        success: function(result) {
          context.app.loading(false);
          console.log(result, "=========================================");
          if (result.rc == 0) {
            if (!result.data.kennel) {
              result.data.kennel = { name: "", nameEn: "" };
            }
            renew.data(result.data);
          } else {
            layer.msg(
              "请求失败,错误代码:" + result.rc + "错误信息:" + result.msg
            );
          }
        }
      });
    };
    renew.select = function() {
      if (renew.samePeriodRenewType() == "1") {
        renew.samePeriodRenewType(renew.samePeriodRenewTypeUrl());
      } else {
        renew.samePeriodRenewType("1");
      }
      renew.renewal();
    };
    //检验犬舍中文名称
    renew.checkKennelName = function() {
      var sendData = { isCheckType: "name", name: renew.data().kennel.name };
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            renew.kennelNameShow("犬舍中文名正确");
            renew.kennelNameCheckFlag(true);
            renew.isNameError(false);
          } else {
            renew.kennelNameShow(json.msg);
            renew.kennelNameCheckFlag(false);
            renew.isNameError(true);
          }
        }
      });
    };
    //检验犬舍英文名称
    renew.checkKennelNameEn = function() {
      var sendData = {
        isCheckType: "nameEn",
        nameEn: renew.data().kennel.nameEn
      };
      util.sendAjax({
        url: "kennel/checkKennelName",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            renew.kennelNameEnShow("犬舍英文名正确");
            renew.kennelNameEnCheckFlag(true);
            renew.isNameEnError(false);
          } else {
            renew.kennelNameEnShow(json.msg);
            renew.kennelNameEnCheckFlag(false);
            renew.isNameEnError(true);
          }
        }
      });
    };
    //勾选按钮
    renew.checkFun = function() {
      if (renew.isCheck() == "0") {
        renew.isCheck("1");
      } else {
        renew.isCheck("0");
      }
    };
    //展现阅读内容
    renew.showFun = function() {
      if ($("#showDiv").css("display") == "none") {
        $("#showEm").addClass("show");
        $("#showDiv").css("display", "block");
      } else {
        $("#showEm").removeClass("show");
        $("#showDiv").css("display", "none");
      }
    };
    renew.save = function() {
      if (
        !(
          renew.data().renewType &&
          renew.data().renewType.lastIndexOf("99911") === -1 &&
          renew.data().renewType &&
          renew.data().renewType.lastIndexOf("99912") === -1 &&
          renew.data().renewType &&
          renew.data().renewType.lastIndexOf("99931") === -1 &&
          renew.data().renewType &&
          renew.data().renewType.lastIndexOf("99932") === -1
        ) &&
        renew.samePeriodRenewType() === "1"
      ) {
        renew.checkKennelName();
        renew.checkKennelNameEn();
        if (!(renew.kennelNameCheckFlag() && renew.kennelNameEnCheckFlag())) {
          layer.msg("犬舍名称不符合规则，请重新确认。");
          return;
        }
        if (renew.isCheck() == "0") {
          layer.msg("请阅读会员注册须知");
          return;
        }
      }
      util.sendAjax({
        url: "member/renewal",
        data: JSON.stringify({
          renewal: renew.data()
        }),
        async: true,
        loadFlag: true,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            context.app.changeCart();
            layer.alert("业务添加成功，是否跳转到业务核对页面进行支付？", {
              time: 0, //不自动关闭
              btn: ["跳转", "取消"],
              yes: function(index) {
                layer.close(index);
                location.href = location.href.split("#")[0] + "#/order/check";
              }
            });
          } else {
            layer.msg(
              "会员续费失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    $(function() {
      var obj = util.getQueryString();
      console.log(obj, "================================================");
      if (obj.samePeriodRenewType) {
        renew.samePeriodRenewTypeUrl(obj.samePeriodRenewType);
      } else {
        renew.samePeriodRenewTypeUrl("0");
      }
      renew.renewal();
    });
    context.app.isShop(false);
  };
});
