define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.semenNumber = ko.observable("");
        //会员信息
        me.memberMsg = ko.observable(userInfo.getMember());
        me.member = ko.observable({});
        me.dogId = ko.observable("");
        //血统证书号 公
        me.malePedigreeCertified = ko.observable("");
        //血统证书号 母
        me.femalePedigreeCertified = ko.observable("");
        //是否加急 默认“是”
        me.urgent = ko.observable("0");
        //配种日期
        me.breedDate = ko.observable("")
        //根据血统证书号查出来的狗信息
        //公狗信息
        me.mydog = ko.observable({});
        //母狗信息
        me.myFemaleDog = ko.observable({});
        //价格
        me.price = ko.observable("0");
        //修改时是否加急
        me.urgentAmend = ko.observable({});
        me.urgentAmend().urgent = "0";
        //是否为修改页
        me.isRepair = ko.observable({});
        //添加
        me.isRepair().text = "1";
        //修改后的返回信息
        me.getAmendMsg = function(msg){
            me.malePedigreeCertified(msg.malePedigreeCertified);
            me.getMalePedigreeCertified(msg.semenCode);
            me.femalePedigreeCertified(msg.femalePedigreeCertified);
            me.getFemalePedigreeCertified();
            me.urgent(msg.urgent);
            me.breedDate(msg.breedDate);
            me.getPrice();
        }
        //是否加急
        me.isUrgent=function(data,event){
            var obj = util.getQueryString();
            if(obj.malePedigreeCertified){
                return false;
            }
            $(event.target).attr("class","radio").siblings("a").removeAttr("class");
            if($(event.target).index()==0){
                me.urgent(1);
            }else{
                me.urgent(0);
            }
            me.getPrice();
        }
        //是否展开注意事项
        me.isOpen = ko.observable(false);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        /**
         * 血统证书列表查询方法
         */
        //公犬查询
        me.getMalePedigreeCertified = function(sencode){
        	debugger;
            var sendData = {};
            var originalSemenCode = [];
            var semenCount = $("#semenCount").val();
            if(semenCount==''){
                layer.msg("请输入精子数量！");
                return;
            }
            var flag = false;
            $(".originalSemenCode").each(function (i,val) {
                if($(this).val()==''){
                    flag = true;
                    return;
                }
                originalSemenCode.push($(this).val());
            });
            if(flag){

                layer.msg("CKU精子编号不能为空");
                return;
            }
            var semenCode= originalSemenCode.join(",");
        	if(sencode==1){//添加页
        		sendData["semenCode"] = semenCode;
        	}else{//修改页
        		sendData["semenCode"] = sencode;
        	}
            sendData["id"] = me.dogId();
            util.sendAjax({
                url:'dog/dognewborn/getDogBySemenCode',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                	debugger;
                    if(json.rc==0){
                        if(json.data!=null){
                           me.mydog(json.data);
                           me.malePedigreeCertified(json.data.pedigreeCertifiedCode);
                        }else{
                            layer.msg("该犬只不在您名下，无法申请该业务！");
                            me.mydog({});
                        }
                    }else{
                        layer.msg("公犬信息查询失败:"+json.msg);
                    }
                }
            });
        }
        //母犬查询
        me.getFemalePedigreeCertified = function(){
            var sendData = {};
            sendData["pedigreeCertifiedCode"] = me.femalePedigreeCertified();
            if(util.checkIsCKU(me.femalePedigreeCertified())==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            util.sendAjax({
                url:'dog/dog/getOneByPedigreeCertified',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.data!=null){
                            if(json.data.gender=="2"){
                                me.myFemaleDog(json.data);
                            }else if(json.data.gender=="1"){
                                layer.msg("性别不符，请输入正确的证书号！");
                                me.myFemaleDog({});
                                me.femalePedigreeCertified("");
                            }
                        }else{
                            layer.msg("找不到犬只信息，请核对血统证书号是否正确!");
                            me.myFemaleDog({});
                        }
                    }else{
                        layer.msg("母犬信息查询失败:"+json.msg);
                    }
                }
            });

        }
        /**
         * 保存
         */
        me.saveCart = function(){
            var endTime = new Date(new Date(util.formatDateLong(me.memberMsg().memberEndDate).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime();
            if(endTime>=0&&me.memberMsg().memberType=="professional") {
                var sendData = {};
            	var originalSemenCode = [];
                var flag = false;
                $(".originalSemenCode").each(function (i,val) {
                    if($(this).val()==''){
                        flag = true;
                        return;
                    }
                    originalSemenCode.push($(this).val());
                });
                if(flag){
                    layer.msg("CKU精子编号不能为空");
                    return;
                }
                var semenCode= originalSemenCode.join(",");
                sendData["semenCode"] = semenCode;
                var malePedigreeCertified = me.malePedigreeCertified();
                if (util.isVal(malePedigreeCertified) == "") {
                    layer.msg("公犬血统证书号不能为空！");
                    return;
                }
                var femalePedigreeCertified = me.femalePedigreeCertified();
                if (util.isVal(femalePedigreeCertified) == "") {
                    layer.msg("母犬血统证书号不能为空！");
                    return;
                }
                if(util.checkIsCKU(femalePedigreeCertified)==0){
                    layer.msg("非CKU开头的犬只不可以申请配种证明！");
                    return;
                };
                if(util.checkIsCKU(malePedigreeCertified)==0){
                    layer.msg("非CKU开头的犬只不可以申请配种证明！");
                    return;
                };
                var breedDate = $("#breedDate").val();
                if (util.isVal(breedDate) == "") {
                    layer.msg("配种日期不能为空！");
                    return;
                }
                sendData["malePedigreeCertified"] = me.malePedigreeCertified();
                sendData["femalePedigreeCertified"] = me.femalePedigreeCertified();
                sendData["urgent"] = "0";
                sendData["breedDate"] = $("#breedDate").val();
                util.sendAjax({
                    url: 'dog/dognewborn',
                    data: JSON.stringify(sendData),
                    async: true,
                    loadFlag: true,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("配种证明申请失败:" + json.msg);
                        }
                    }
                });
            }else{
                layer.msg("该业务仅限有效专业会员办理!");
            }
        }
        /**
         * 发送修改
         */
        me.saveRepair = function() {
            var sendData = {};
            var originalSemenCode = [];
            var semenCount = $("#semenCount").val();
            if(semenCount==''){
                layer.msg("请输入精子数量！");
                return;
            }
            var flag = false;
            $(".originalSemenCode").each(function (i,val) {
                if($(this).val()==''){
                    flag = true;
                    return;
                }
                originalSemenCode.push($(this).val());
            });
            if(flag){
                layer.msg("CKU精子编号不能为空");
                return;
            }
            var semenCode= originalSemenCode.join(",");
        	sendData["semenCode"] = semenCode;
            var malePedigreeCertified = me.malePedigreeCertified();
            if (util.isVal(malePedigreeCertified) == "") {
                layer.msg("公犬血统证书号不能为空！");
                return;
            }
            var femalePedigreeCertified = me.femalePedigreeCertified();
            if (util.isVal(femalePedigreeCertified) == "") {
                layer.msg("母犬血统证书号不能为空！");
                return;
            }
            if(util.checkIsCKU(femalePedigreeCertified)==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            if(util.checkIsCKU(malePedigreeCertified)==0){
                layer.msg("非CKU开头的犬只不可以申请配种证明！");
                return;
            };
            var breedDate = $("#breedDate").val();
            if (util.isVal(breedDate) == "") {
                layer.msg("配种日期不能为空！");
                return;
            }
            sendData["malePedigreeCertified"] = me.malePedigreeCertified();
            sendData["femalePedigreeCertified"] = me.femalePedigreeCertified();
            sendData["breedDate"] = $("#breedDate").val();
            var obj = util.getQueryString();
            sendData["id"] = obj.id;
            util.sendAjax({
                url: 'dog/dognewborn',
                data: JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type: 'PUT',
                cache: false,
                success: function (json) {
                    if (json.rc == 0) {
                        layer.msg("修改成功！");
                        location.href = location.href.split("#")[0]+"#/dog/dognewbornlist"
                    } else {
                        layer.msg("修改失败:"+json.msg);
                    }
                }
            });
        }
        //配种证明订单金额
        me.getPrice = function(){
            var payData = {};
            payData["urgent"] = "0";

            var malePedigreeCertified = me.malePedigreeCertified();
            if (util.isVal(malePedigreeCertified) == "") {
                layer.msg("公犬血统证书号不能为空！");
                return;
            }
            var femalePedigreeCertified = me.femalePedigreeCertified();
            if (util.isVal(femalePedigreeCertified) == "") {
                layer.msg("母犬血统证书号不能为空！");
                return;
            }
            payData["malePedigreeCertified"] = malePedigreeCertified;
            payData["femalePedigreeCertified"] = femalePedigreeCertified;
            if(me.breedDate()==""){
                payData["breedDate"] = $("#breedDate").val();
            }else{
                payData["breedDate"] = me.breedDate();
            }
            util.sendAjax({
                url:'dog/dognewborn/getPrice',
                data:payData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        me.price(json.data["price"]);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }
        //改变配种日期
        me.changeDate = function(){
            var timer = setInterval(function(){
                if(me.breedDate()!=$("#breedDate").val()){
                    me.breedDate($("#breedDate").val());
                    clearInterval(timer);
                    me.getPrice();
                }
            },100)
        } 
        //添加精子编号输入框
        me.changeLine = function(){
            var num = parseInt(me.semenNumber());
            if(num<1||num>99){
            	layer.msg("请输入1-99之间的精子数量!");
            	$("#semenCount").val();
            	return;
            }
            var html = '';
            for (var i = 0; i < num; i++) {
                html += '<input id=code'+i+' type="text" class="originalSemenCode"/> ';
            }
            $("#semenCode").html(html);
        }
        

        $(function(){
        	var obj = util.getQueryString();
        	var timer;
        	if(obj.malePedigreeCertified){
        		debugger;
        		var semenCode=obj.semenCode;
        		ss = semenCode.split(",");
        		me.semenNumber(ss.length);
        		me.dogId(obj.id);
        		//修改
        		me.isRepair().text = "2";
        		me.getAmendMsg(obj);
        		$('#femalePedigreeCertifiedinp').attr("disabled",true);
        		var timer = setTimeout(function(){
        			me.changeLine();
        			for(var i=0;i<ss.length;i++){
        				$("#code"+i).val(ss[i]);
        			}
        		},1000);
        	}
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});
