<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只精子管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctxDc}/dogSemen">犬只精子列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogSemen" action="${ctxDc}/dogSemen" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>冷冻精子批次号：</label>
            <form:input path="semenBatchCodeLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>血统证书/芯片号：</label>
            <form:input path="pedigreeCertifiedAndDogChipLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>CKU精子编号：</label>
            <form:input path="semenCodeLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>精子主人/会员号：</label>
            <form:input path="memberCodeAndMemberNameLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>

        <li><label>犬名：</label>
            <form:input path="dogNameLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>冷冻精子批次号</th>
        <th>犬只血统证书号</th>
        <th>犬只芯片</th>
        <th>犬种号</th>
        <th>精子主人</th>
        <th>CKU精子编号</th>
        <th>配种证明编号</th>
        <th>采集时间</th>
        <th>修改时间</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogSemen">
        <tr>
            <td>
                    ${fns:escapeHtml(dogSemen.semenBatchCode) }
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.pedigreeCertified) }
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.dogChip) }
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.dogBreed) }
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.memberName) }(${fns:escapeHtml(dogSemen.memberCode) })
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.semenCode) }
            </td>
            <td>
                    ${fns:escapeHtml(dogSemen.breedCertifiedCode) }
            </td>
            <td>
                <fmt:formatDate value="${dogSemen.acquisitionTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${dogSemen.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    <a href="${ctxDc}/dogSemen/form?id=${dogSemen.id}">查看</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>