<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作学校管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

            if(${trainingInstitution.firstSchoolType==2}){
				$("#showSchoolType").show();
			}else{
				$("#showSchoolType").hide();
			}
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//删除学校类型为1和7的
			$("#schoolType option").each(function() {
				var text = $(this).text(); //获取option的text
				var value = $(this).val(); //获取option的value
				if(value=="1"||value=="2" || value=="7" ){
					$(this).remove();
				}else{
				}
			});
            $("#firstSchoolType").change(function(){
                var value =  $("#firstSchoolType option:selected").val();
                if(value==2){
                    $("#showSchoolType").show();
                }else{
                    $("#showSchoolType").hide();
                }
            });

		});


	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/trainschool/trainingInstitution/handlerForm?id=${trainingInstitution.id}">合作学校<shiro:hasPermission name="trainschool:handler:edit">${not empty trainingInstitution.id?'修改':'添加'}</shiro:hasPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="trainingInstitution" action="${ctx}/trainschool/trainingInstitution/handlerSave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">机构中文：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构英文：</label>
			<div class="controls">
				<form:input path="schoolNameEn" htmlEscape="false" maxlength="100" class="input-xlarge  required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构英文缩写：</label>
			<div class="controls">
				<form:input path="schoolShortName" htmlEscape="false" maxlength="64" class="input-xlarge isEnglish required"/>
				<ul>
					<li><font color="red">注:生成证书号必备!</font></li>
				</ul>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">负责人：</label>
			<div class="controls">
				<form:input path="responsibler" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				<form:input path="telephone" htmlEscape="false" maxlength="64" class="input-xlarge isTel required"/>
			</div>
		</div>
				<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-large required">
					<form:option value="" label="请选择"/>
					<c:forEach items="${province}" var="p">
						<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-large required">
					<form:option value="" label="请选择"/>
					<c:forEach items="${city}" var="c">
						<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				//异步请求数据
				var url="${ctx}"+"/sys/area/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")

			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">旧地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" readonly="true" maxlength="150" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">网址：</label>
			<div class="controls">
				<form:input path="schoolWeb" htmlEscape="false" maxlength="150" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${trainingInstitution.startDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${trainingInstitution.endDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校类别：</label>
            <div class="controls">
                <form:select path="firstSchoolType" class="input-medium required">
                    <form:option value="" label="请选择"/>
                    <form:options items="${fns:getDictList('first_school_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
                </form:select>
            </div>

			<div class="controls" id="showSchoolType">
				<form:select path="schoolType" class="input-medium required">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('school_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
				</form:select>
			</div>

		</div>
		<div class="control-group">
			<label class="control-label">官网是否显示：</label>
			<div class="controls">
				<form:select path="displayOnWeb" class="input-medium required">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group" style="width:80%">
			<label class="control-label">学校logo：</label><span class="help-inline">
			<div class="controls" style="width: 400px;">
				<sys:singleImgUpload module="trainingInstitution"  imgId="${trainingInstitution.avatar}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" id="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>

			</div>
		</div>

		<div class="form-actions">
			<shiro:hasPermission name="trainschool:handler:edit"><input id="btnSubmit" class="btn btn-primary" type="button" onclick="msgAlert()" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
		<script type="text/javascript">
			function msgAlert(){
				var id = $("#id").val();
				if(id==''){
					$("#inputForm").submit();
				}else{
					layer.confirm('该操作将同时更新同名学校的地址与电话!', {
						btn: ['确认','取消'] //按钮
					}, function(){
						$("#inputForm").submit();
					}, function(){
						layer.msg('已取消');
					});
				}
			}
		</script>
	</form:form>
</body>
</html>