<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>淘宠宝犬舍管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/tcb/tcbKennel/">淘宠宝犬舍列表</a></li>
		<shiro:hasPermission name="tcb:tcbKennel:add"><li><a href="${ctx}/tcb/tcbKennel/addForm">淘宠宝犬舍添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="tcbKennel" action="${ctx}/tcb/tcbKennel/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员编号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>当前状态：</label>
				<form:select path="valid" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="有效"/>
					<form:option value="1" label="无效"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>犬舍名称</th>
				<th>截至日期</th>
				<th>当前状态</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="tcbKennel">
			<tr>
				<td>
					${fns:escapeHtml(tcbKennel.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(tcbKennel.member.name)}
				</td>
				<td>
					${fns:escapeHtml(tcbKennel.member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(tcbKennel.kennel.name)}
				</td>
				<td>
					<fmt:formatDate value="${tcbKennel.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${tcbKennel.valid=='0'}">有效</c:if>
					<c:if test="${tcbKennel.valid=='1'}">无效</c:if>
				</td>
				<td>
					<shiro:hasPermission name="tcb:tcbKennel:view">
						<a href="${ctx}/tcb/tcbKennel/form?id=${tcbKennel.id}">查看</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="tcb:tcbKennel:edit">
						<a href="${ctx}/tcb/tcbKennel/editForm?id=${tcbKennel.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="tcb:tcbKennel:delete">
						<a href="${ctx}/tcb/tcbKennel/delete?id=${tcbKennel.id}" onclick="return confirmx('确认要删除该淘宠宝犬舍吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>