<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展秩序册管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/showReportScore/">犬展秩序册列表</a></li>
		<li class="active"><a href="${ctx}/show/showReportScore/form?id=${showReportScore.id}">犬展秩序册查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showReportScore" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
				${showReportScore.showCode}
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">秩序号：</label>
			<div class="controls">
					${showReportScore.orderNumber}
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
					${showReportScore.pedigreeCertifiedCode}
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">FCI代码：</label>
			<div class="controls">
					${showReportScore.fciCode}
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">性别：</label>
			<div class="controls">
					${showReportScore.dogSex}
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
					${fns:getDictLabel(showReportScore.dogYearGroup, 'show_age_group', '')}
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">裁判：</label>
			<div class="controls">
				${showReportScore.judgeName}
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">活动区域：</label>
			<div class="controls">
					${showReportScore.showCircle}
			</div>

		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
					${showReportScore.dogOwnerZh}
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
					${showReportScore.dogOwnerCode}
			</div>
		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬种中文：</label>
			<div class="controls">
					${showReportScore.dogTypeZh}
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬种英文：</label>
			<div class="controls">
					${showReportScore.dogTypeEn}
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬名：</label>
			<div class="controls">
					${showReportScore.dogName}
			</div>
		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主牵犬师：</label>
			<div class="controls">
					${showReportScore.dogOwnerHandler}
			</div>
		</div>

		<div class="control-group"  style="width: 100%;float: left">
			<label class="control-label">修改说明：</label>
			<div class="controls">
					${showReportScore.remarks}
			</div>
		</div>


		<div class="form-actions" style="width: 89%;float: right;">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>