<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>CKU审查员管理</title>
    <meta name="decorator" content="default"/>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/judgecertificate/showJudgeCertificate/">CKU审查员列表</a></li>
    <shiro:hasPermission name="judgecertificate:showJudgeCertificate:view">
        <li class="active"><a href="#">CKU审查员查看</a></li>
    </shiro:hasPermission>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="showJudgeCertificate"
           action="${ctx}/judgecertificate/showJudgeCertificate/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">中文名：</label>
        <div class="controls">
            ${fns:escapeHtml(showJudgeCertificate.name)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">英文名：</label>
        <div class="controls">
            ${fns:escapeHtml(showJudgeCertificate.nameEn)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">证书号：</label>
        <div class="controls">
            ${fns:escapeHtml(showJudgeCertificate.judgeCertificate)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审查员类型;：</label>
        <div class="controls">
                ${fns:getDictLabel(showJudgeCertificate.certificateType, 'certificate_type', '')}
        </div>
    </div>
    <c:if test="${showJudgeCertificate.certificateType !='3'}">
        <div class="control-group" id="signDateDiv">
            <label class="control-label">签发日期：</label>
            <div class="controls">
                <fmt:formatDate value="${showJudgeCertificate.signDate}" pattern="yyyy-MM-dd"/>
            </div>
        </div>

        <div class="control-group" id="engDateDiv">
            <label class="control-label">有效日期：</label>
            <div class="controls">
                <fmt:formatDate value="${showJudgeCertificate.endDate}" pattern="yyyy-MM-dd"/>
            </div>
        </div>
    </c:if>
    <div class="control-group">
        <label class="control-label">是否在页面显示：</label>
        <div class="controls">
            ${fns:getDictLabel(showJudgeCertificate.visibleFlag, 'visible_flag', '')}
        </div>
    </div>
    <c:if test="${showJudgeCertificate.certificateType =='8' || showJudgeCertificate.certificateType =='9'}">
        <div class="control-group">
            <label class="control-label">有效日期是否展示：</label>
            <div class="controls">
                    ${fns:getDictLabel(showJudgeCertificate.expirationDateVisibleFlag, 'visible_flag', '')}
            </div>
        </div>
    </c:if>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
             ${fns:escapeHtml(showJudgeCertificate.sort)}
        </div>
    </div>
    <c:if test="${showJudgeCertificate.certificateType=='3'}">
        <div class="control-group" id="groupDiv">
            <label class="control-label">犬种组信息：</label>
            <div class="controls">
                <table id="contentTable" class="table table-striped table-bordered table-condensed">
                    <thead>
                    <tr>
                        <th class="hide"></th>
                        <th>犬种证书号</th>
                        <th>通过犬种组</th>
                        <th>签发日期</th>
                        <th>有效日期</th>
                        <th>是否在页面展示</th>
                    </tr>
                    </thead>
                    <tbody id="testDataChildList">
                        <c:forEach items="${showJudgeCertificate.showJudgeCertificateDogGroupList}" var="showJudgeCertificateDogGroup">
                            <tr>
                                <td>${showJudgeCertificateDogGroup.judgeCertificate}</td>
                                <td>${showJudgeCertificateDogGroup.groupNo}</td>
                                <td><fmt:formatDate value="${showJudgeCertificateDogGroup.signDate}" pattern="yyyy-MM-dd"/></td>
                                <td><fmt:formatDate value="${showJudgeCertificateDogGroup.endDate}" pattern="yyyy-MM-dd"/></td>
                                <td>${fns:getDictLabel(showJudgeCertificateDogGroup.visibleFlag, 'visible_flag', '')}</td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </div>
        </div>
    </c:if>
    <c:if test="${showJudgeCertificate.certificateType=='4'}">
        <div class="control-group" id="dogBreedNameDiv">
            <label class="control-label">通过犬种：</label>
            <div class="controls">
                    ${fns:escapeHtml(showJudgeCertificate.dogBreedName)}
            </div>
        </div>
        <div class="control-group" id="dogBreedCodeDiv">
            <label class="control-label">FCI编码：</label>
            <div class="controls">
                    ${fns:escapeHtml(showJudgeCertificate.dogBreedCode)}
            </div>
        </div>
    </c:if>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>