<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>采样包添加</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//保存事件
			$("#btnSubmit").click(function () {
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
							return false;
						} else {
							return true;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg(data.data);
							parent.isYes = true;
							parent.layer.closeAll();
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});
		});

		function closeLayer(){
			parent.layer.closeAll();
		}

	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>
	<form:form id="inputForm" modelAttribute="sampling" action="${ctx}/sampling/sampling/add" method="post" class="form-horizontal">
		<div class="control-group">
			<label class="control-label">采样包编号：</label>
			<div class="controls">
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="sampling:sampling:add"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>