<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>ip列表</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/ipaddress/ipAddress/">ip列表</a></li>
		<%-- <shiro:hasPermission name="ipaddress:ipAddress:edit"><li><a href="${ctx}/ipaddress/ipAddress/form">ip映射表添加</a></li></shiro:hasPermission> --%>
	</ul>
	<form:form id="searchForm" modelAttribute="ipAddress" action="${ctx}/ipaddress/ipAddress/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		
		
		<ul class="ul-form">
			<li><label>ip：</label>
				<form:input path="ip" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<td>ip</td>
				<th>时间</th>
				<td>当日请求次数</td>
				<shiro:hasPermission name="ipaddress:ipAddress:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ipAddress">
			<tr>
				<td>
					${ipAddress.ip}
				</td>
				<td>
					${ipAddress.today}
				</td>
				<td>
					${ipAddress.count}
				</td>
				<shiro:hasPermission name="ipaddress:ipAddress:edit"><td>
    				<a href="${ctx}/ipaddress/ipAddress/saveBlack?ip=${ipAddress.ip}" onclick="return confirmx('确认要添加到黑名单吗？', this.href)">添加到黑名单</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>