<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>FCI资格证书查看</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active">
			<c:if test="${groomerQualificationCertificate.certificateType==1}"><a href="${ctx}/groomer/groomerQualificationCertificate/view?id=${groomerQualificationCertificate.id}">美容资格证书查看</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==2}"><a href="${ctx}/groomer/groomerQualificationCertificate/view?id=${groomerQualificationCertificate.id}">国际宠物美容师证书查看</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==3}"><a href="${ctx}/groomer/groomerQualificationCertificate/view?id=${groomerQualificationCertificate.id}">宠物造型师证书查看</a></c:if>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="fciGroomerQualificationCertificate"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<h3>会员基本信息</h3>	
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">取证日期：</label>
			<div class="controls">
				<fmt:formatDate value="${fciGroomerQualificationCertificate.takeCertificateDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				${fns:escapeHtml(fciGroomerQualificationCertificate.fciCertificateCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
					${fns:getDictLabel(fciGroomerQualificationCertificate.levelEn, 'groomer_test_level', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<fmt:formatDate value="${fciGroomerQualificationCertificate.issueDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				${fns:escapeHtml(fciGroomerQualificationCertificate.groomerShow.showName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				${fns:escapeHtml(fciGroomerQualificationCertificate.groomerRegister.showCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
					${fns:getDictLabel(fciGroomerQualificationCertificate.levelEn, 'groomer_test_level', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">成绩：</label>
			<div class="controls">
				${fns:getDictLabel(fciGroomerQualificationCertificate.groomerRegister.grade, 'Grade', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员：</label>
			<div class="controls">
					${fns:escapeHtml(fciGroomerQualificationCertificate.referee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(fciGroomerQualificationCertificate.remarks) }
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>