<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬主变更申请管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
            $(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
        function openReviewPage(id){
            parent.layer.open({
                type: 2,
                title: ['犬主变更审核', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['560px', '480px'],
                content: ctx+"/dogownerchange/dogOwnerChange/review?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            }); 
        };
        function changeProcessState(id){
        	var msg=confirm("确认要处理该犬只变更申请吗？");
        	if(msg==true){
                $.ajax({
                    type: "POST",
                    url:"${ctx}/dogownerchange/dogOwnerChange/process?id="+id,
                    dataType:"json",
                    async: false,
                    error: function(request, textStatus, errorThrown) {
                        alert("系统错误，请联系管理员！");
                    },
                    success: function(data) {
                        if(data.rc==0){
                            alert("处理成功");
                            var mainF = parent.$("#mainFrame");
                            mainF.contents().find("#searchForm").submit();
                        }else {
                            alert("错误代码："+data.rc+"错误信息："+data.msg);
                            parent.isYes = false;
                        }
                    }
                });
            } else {
                return;
            }
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogownerchange/dogOwnerChange/?dogBreed=230">犬主变更申请列表</a></li>
		<shiro:hasPermission name="dogownerchange:dogOwnerChange:edit"><li><a href="${ctx}/dogownerchange/dogOwnerChange/form?dog.dogBreed=230">犬主变更申请添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogOwnerChange" action="${ctx}/dogownerchange/dogOwnerChange/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input type="hidden" value="230" name="dog.dogBreed" htmlEscape="false">
		<input type="hidden" value="230" name="dogBreed" >
		<ul class="ul-form">
		    <li><label>血统证书号：</label>
                <form:input path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>会员号/姓名：</label>
				<form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核人：</label>
				<form:input path="reviewer" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>付款状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>创建时间：</label>
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			    <th>血统证书号</th>
				<th>原犬主姓名</th>
				<th>新犬主姓名</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>审核人</th>
				<th>处理状态</th>
				<th>查看</th>
				<shiro:hasPermission name="dogownerchange:dogOwnerChange:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogOwnerChange">
			<tr>
			    <td>
			        ${fns:escapeHtml(dogOwnerChange.dog.pedigreeCertifiedCode) }
			    </td>
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.originOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.originOwnerName) }
				</td >
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.newOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.newOwnerName) }
				</td>
				<td>
                    <fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${dogOwnerChange.paymentState==1}"><font color="red">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                    <c:if test="${dogOwnerChange.paymentState==2}"><font color="green">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                </td>
                <td title="${fns:escapeHtml(dogOwnerChange.reviewRemarks) }">
                    <a onclick="openReviewPage('${dogOwnerChange.id}')">
	                    <c:if test="${dogOwnerChange.reviewState==0}"><font color="red"></c:if>
	                        ${fns:getDictLabel(dogOwnerChange.reviewState, 'review_state', '')}
	                    <c:if test="${dogOwnerChange.reviewState==0}"></font></c:if>
                    </a>
                </td>
				<td>
					${fns:escapeHtml(dogOwnerChange.reviewer) }
				</td>
				<td>
				    <c:if test="${dogOwnerChange.processState==0}"><a onclick="changeProcessState('${dogOwnerChange.id}')">${fns:getDictLabel(dogOwnerChange.processState, 'proccess_state', '')}</a></c:if>
                    <c:if test="${dogOwnerChange.processState==1}">${fns:getDictLabel(dogOwnerChange.processState, 'proccess_state', '')}</c:if>
				</td>
				<td>
				<a href="${ctx}/dogownerchange/dogOwnerChange/view?id=${dogOwnerChange.id}">查看</a>
				</td>
				<shiro:hasPermission name="dogownerchange:dogOwnerChange:edit"><td>
    				<a href="${ctx}/dogownerchange/dogOwnerChange/edit?id=${dogOwnerChange.id}">编辑</a><%-- onclick="openEditPage('${dogOwnerChange.id}')" --%>
					<a href="${ctx}/dogownerchange/dogOwnerChange/delete?id=${dogOwnerChange.id}" onclick="return confirmx('确认要删除该犬主变更申请吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>