<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>双亲比对订单录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					var pedigreeCertified = $("#pedigreeCertified").val();
					var birthCode = $("#birthCode").val();
					if(pedigreeCertified==''&&birthCode==''){
						alert("请输入血统证书号或出生纸编号");
						return;
					}
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogdnaparentscompare/dogDnaParentsCompare/add',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("订单录入成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("提交失败,错误信息："+data.msg);
 						} 
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function getDogByPedigreeCertified(){
			var pedigreeCertified = $("#pedigreeCertified").val();
			if(pedigreeCertified==''){
				$.jBox.alert("请输入血统证书号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dnaarchive/dogDnaArchive/getDogByPedigreeCertified', {
		    	pedigreeCertified: pedigreeCertified
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
		    });
		}
		function getDogByBirthCode(){
			var birthCode = $("#birthCode").val();
			if(birthCode==''){
				$.jBox.alert("请输入出生纸编号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dnaarchive/dogDnaArchive/getDogByBirthCode', {
				birthCode: birthCode
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
		    });
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogDnaParentsCompare" class="form-horizontal">
	<form:hidden path="paymentMemberCode"/>
	<form:hidden path="paymentChargingItemId"/>
	<form:hidden path="runningNumber"/>
	<div class="control-group">
		<label class="control-label">血统证书号：</label>
		<div class="controls">
			<form:input id="pedigreeCertified" path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge"/>
			<input class="btn" type="button" value="查询" onclick="getDogByPedigreeCertified()"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出生纸编号：</label>
		<div class="controls">
			<form:input id="birthCode" path="birthCode" htmlEscape="false" maxlength="64" class="input-xlarge"/>
			<input class="btn" type="button" value="查询" onclick="getDogByBirthCode()"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬种：</label>
		<div class="controls" id="dogBreed"></div>
	</div>
	<div class="control-group">
		<label class="control-label">犬名：</label>
		<div class="controls" id="nameEn"></div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls" id="birthdate"></div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls" id="gender"></div>	
	</div>
	<div class="control-group">
		<label class="control-label">毛色：</label>
		<div class="controls" id="colorFlag"></div>
	</div>
	<div class="control-group">
		<label class="control-label">身份标识：</label>
		<div class="controls" id="identificationFlag"></div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>