<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>DNA信息管理</title>
    <meta name="decorator" content="default"/>
    <script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //初始化
            //是否只读
            let isView = '${isView}';
            if (isView == 1) {
                $('#btnSubmit').hide();
                $('#inputForm input').attr('disabled', 'true');
                $('#inputForm select').attr('disabled', 'true');
                $('#inputForm textarea').attr('disabled', 'true');
                $('#inputForm input').unbind();
                $('#btnCancel').removeAttr('disabled');
                $('#samplingSearchBtn').hide();
                $('#samplingMemberDiv').hide();
            } else {
                //是否新增
                let id = '${dogDna.id}';
                let dogBreed = '${dogDna.dogBreed}';
                if (id) {
                    //修改
                    $('#detectionType').attr('disabled', 'true');
                    $('#samplingCode').attr('readOnly', 'true');
                    $('#samplingSearchBtn').hide();
                    $('#samplingMemberDiv').hide();
                    $('#dnaCode').attr('readOnly', 'true');
                } else {
                    //新增
                    $('#activeStateDiv').hide();
                    if(!dogBreed.toUpperCase().startsWith("NB")) {
                        $('#dnaCodeDiv').hide();
                        $('#dnaCode').attr('readOnly', 'true');
                    }
                }
            }

            $("#detectionType").change(function () {
                var value = $(this).val();
                if (value == '0') {
                    $('#samplingCode').val("")
                    $('#samplingCode').attr('readOnly', 'true');
                } else {
                    $('#samplingCode').removeAttr('readOnly');
                }
            });

            //保存事件
            $("#btnSubmit").click(function () {
                let id = $("#id").val();
                let detectionType = $("#detectionType").val();
                if (detectionType == 1 && id == '') {
                    let samplingMemberName = $("#samplingMemberNameDiv").html().trim();
                    if (samplingMemberName == '') {
                        alert("请先查询采样包归属人");
                        return;
                    }
                }
                $("#inputForm").ajaxSubmit({
                    dataType: 'json',
                    beforeSubmit: function () {
                        if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
                            return false;
                        } else {
                            return true;
                        }
                    },
                    success: function (data) {
                        if (data.rc == 0) {
                            layer.msg(data.data);
                            window.location = "${ctx}/dna/dogDna/list?dogId=${dogDna.dogId}"
                        } else {
                            layer.msg(data.msg);
                        }
                    },
                    error: function (err) {
                        layer.msg("操作失败!");
                    }
                });
            });
        });

        function findBySamplingCode() {
            var samplingCode = $("#samplingCode").val();
            if (samplingCode == '') {
                alert("请输入采样包编号");
                return;
            }
            $.ajax({
                type: "GET",
                url: "${ctx}/sampling/sampling/samplingCode?samplingCode=" + samplingCode,
                async: false,
                success: function (json) {
                    let data = eval(json);
                    if (data.rc == 0) {
                        if (data.data.bindType == 1) {
                            alert("该采样包已被使用");
                            $("#samplingMemberNameDiv").html("");
                        } else {
                            if (data.data.memberName == '') {
                                $("#samplingMemberNameDiv").html('无');
                            } else {
                                $("#samplingMemberNameDiv").html(data.data.memberName);
                            }
                        }
                    } else {
                        $("#samplingMemberNameDiv").html("");
                        layer.msg(data.msg);
                    }
                },
                error: function (err) {
                    layer.msg("操作失败!");
                }
            });
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dna/dogDna/list?dogId=${dogDna.dogId}">DNA信息列表</a></li>
    <li class="active">
        <c:choose>
            <c:when test="${not empty dogDna.id and isView == 1}">
                <a href="${ctx}/dna/dogDna/viewForm?id=${dogDna.id}">DNA信息查看</a>
            </c:when>
            <c:when test="${not empty dogDna.id and isView == 0}">
                <a href="${ctx}/dna/dogDna/editForm?id=${dogDna.id}">DNA信息修改</a>
            </c:when>
            <c:otherwise>
                <a href="${ctx}/dna/dogDna/editForm?dogId=${dogDna.dogId}">DNA信息添加</a>
            </c:otherwise>
        </c:choose>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogDna" action="${ctx}/dna/dogDna/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <form:hidden path="dogId"/>
    <form:hidden path="pedigreeCertifiedCode"/>
    <form:hidden path="dogBreed"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">检测类型：</label>
        <div class="controls">
            <form:select path="detectionType" class="input-medium required">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('detection_type')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <font color="#FF0000">* </font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">采样包编号：</label>
        <div class="controls">
            <form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-xlarge"/>
            <button id="samplingSearchBtn" type="button" class="btn btn-primary" onclick="findBySamplingCode()">查询
            </button>
        </div>
        <div id="samplingMemberDiv">
            <label class="control-label">采样包归属人：</label>
            <div class="controls" id="samplingMemberNameDiv">
            </div>
        </div>
    </div>
    <div id="activeStateDiv" class="control-group">
        <label class="control-label">激活状态：</label>
        <div class="controls">
            <form:select path="activeState" class="input-medium" disabled="true">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('active_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div id="dnaCodeDiv" class="control-group">
        <label class="control-label">DNA编号：</label>
        <div class="controls">
            <form:input path="dnaCode" htmlEscape="false" maxlength="64" class="input-large "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">DNA鉴定结果：</label>
        <div class="controls">
            <form:textarea path="dnaResult" htmlEscape="false" maxlength="500" class="input-xxlarge"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <form:textarea path="dnaResultRemark" htmlEscape="false" maxlength="200" class="input-xlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="dna:dogDna:edit"><input id="btnSubmit" class="btn btn-primary" type="button"
                                                           value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>