<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>黑名单表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/blacklist/blacklist/">黑名单表列表</a></li>
    <shiro:hasPermission name="blacklist:blacklist:edit">
        <li><a href="${ctx}/blacklist/blacklist/form">黑名单表添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="blacklist" action="${ctx}/blacklist/blacklist/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>会员号：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>模块：</label>
            <form:input path="module" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>会员号</th>
        <th>模块</th>
        <th>禁用开始时间</th>
        <th>禁用结束时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="blacklist:blacklist:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="blacklist">
        <tr>
            <td><a href="${ctx}/blacklist/blacklist/form?id=${blacklist.id}">
                    ${blacklist.memberCode}
            </a></td>
            <td>
                    ${blacklist.module}
            </td>
            <td>
                <fmt:formatDate value="${blacklist.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${blacklist.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${blacklist.remarks}
            </td>
            <shiro:hasPermission name="blacklist:blacklist:edit">
                <td>
                    <a href="${ctx}/blacklist/blacklist/form?id=${blacklist.id}">修改</a>
                    <a href="${ctx}/blacklist/blacklist/delete?id=${blacklist.id}"
                       onclick="return confirmx('确认要删除该黑名单表吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>