<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鉴赏课报名管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			// 导出
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出报名信息吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/appreciation/appreciationApply/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});

			
			// 导入
			 $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"报名信息导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });
			

			// 批量排课
			$("#batchArrange").click(function(){
				var ids = "";
				$(".checkedId:checked").each(function(){
					ids +=$(this).attr("applyId")+',';
				});
				if(ids == ''){
					alert("请至少选择一位记录");
					return false;
				};
				parent.layer.open({
					type: 2,
					title: ['批量排课', 'font-size:18px;text-align: center;'],
					shadeClose: false,
					shade: [0.8, '#393D49'],
					maxmin: false, //开启最大化最小化按钮
					area: ['700px', '300px'],
					content: "${ctx}/appreciation/appreciationApply/formArrange?id=" + ids + "&arrangeType=" + 2,
					end: function () {
				        location.reload();
				     }
				});
			});
		

			// 初始化省市区
			initAddress();
			
			// ===== 省市区联动  =====
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option  value='' code=''>全部</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#city").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>全部</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#area").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
			//显示导入错误提示
			var importError = "${importError}";
			var reg = new RegExp("##", "g")
			if (importError != null && importError != '' && typeof importError != 'undefined') {
			    alert(importError.replace(reg, "\n"));
			}
		});
		
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/appreciation/appreciationApply/");
			var	memberKeyword = $('#memberKeyword').val();
			if(memberKeyword != ''){
				$('#memberKeyword').val( encodeURIComponent($('#memberKeyword').val()) );
			}
			$("#searchForm").submit();
        	return false;
        }
        
		// 排课
		function arrange(id){
			parent.layer.open({
				type: 2,
				title: ['批量排课', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '300px'],
				content: "${ctx}/appreciation/appreciationApply/formArrange?id=" + id + "&arrangeType=" + 1 ,
				end: function () {
			        location.reload();
			     }
			});
		}
		
		// 编辑地址,店名，用户名
		function editAddress(id){
			parent.layer.open({
				type: 2,
				title: ['报名信息编辑', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '300px'],
				content: "${ctx}/appreciation/appreciationApply/formAddress?id=" + id ,
				end: function () {
			        location.reload();
			     }
			});
		}

		// 全选/取消全选
		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}
		}
		
        function initAddress(){
			var oldProvince = '${appreciationApply.province}';
			var oldCity = '${appreciationApply.city}';
			var oldArea = '${appreciationApply.area}';

			var oldProvinceCode = "";
			var oldCityCode = "";
			
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				async: false,
				success:function(json){
					if(json.rc==0){
						var html = "<option  value='' code=''>全部</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							if(lists[i].province == oldProvince){
								oldProvinceCode = lists[i].provinceId;
							}
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						}
						$("#province").append(html);
						if(oldProvince != ''){
							$("#province").val(oldProvince);
						}
						$("#province").trigger("change");
					}else{
						layer.msg(json.msg);
					}
				}
			});

			$.ajax({
				url:'${ctxCity}',
				data: {province_code:oldProvinceCode},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				async: false,
				success:function(json){
					if(json.rc==0){
						var html = "<option  value='' code=''>全部</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							if(lists[i].city == oldCity){
								oldCityCode = lists[i].cityId;
							}
							html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
						}
						$("#city").append(html);
						if(oldCity != ''){
							$("#city").val(oldCity);
						}
						$("#city").trigger("change");
				        
					}else{
						layer.msg(json.msg);
					}
				}
			});

			$.ajax({
				url:'${ctxArea}',
				data: {city_code:oldCityCode},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option  value='' code=''>全部</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
						}
						$("#area").append(html);
						if(oldArea != ''){
							$("#area").val(oldArea);
						}
						 $("#area").trigger("change");
					}else{
						layer.msg(json.msg);
					}
				}
			});

        }
	</script>
</head>
<body>

	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/appreciation/appreciationApply/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctxStatic}/modules/xlsx/报名信息导入模版.xlsx">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/appreciation/appreciationApply/">鉴赏课报名列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="appreciationApply" action="${ctx}/appreciation/appreciationApply/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberKeyword" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="applyCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>手机号：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			
			<li>
				<label>会员类型：</label>
				<form:select path="memberCardType" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			
			<li><label>报名渠道：</label>
				<form:input path="applyChannel" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			
			<li><label>所在地：</label>
				<form:select id="province" path="province" class="input-small">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="city" path="city" class="input-small">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="area" path="area" class="input-small">
					<form:option value="" code=""></form:option>
				</form:select>
			</li>
			
			<li><label>店名：</label>
				<form:input path="shopName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>参加课程：</label>
				<form:input path="courseName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			
			<li>
				<label>缴费状态：</label>
				<form:select path="paymentState" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
				
			<li class="btns">
				<input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();" />
			</li>
			<li class="btns">
				<button id="btnExport" type="button" class="btn btn-primary" >导出报名信息</button>
			</li>
			<li class="btns">
				<button id="batchArrange" type="button" class="btn btn-primary" >批量排课</button>
			</li>
			<li class="btns">
				<button id="btnImport" type="button" class="btn btn-primary" >导入报名信息</button>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a id="allCheckAlabel" href="#" onclick="allCheck()"><input type="checkbox"/></a></th>
				<th>报名序号</th>
				<th>报名渠道</th>
				<th>报名时间</th>
				<th>会员号</th>
				<th>会员类型</th>
				<th>姓名</th>
				<th>手机号</th>
				<th>店名</th>
				<th>所在地</th>
				<th>缴费状态</th>
				<th>参加课程</th>
				<th>课程状态</th>
				<th>电子证书</th>
				<shiro:hasPermission name="appreciation:appreciationApply:edit">
            	<th>操作</th>
        		</shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appreciationApply">
			<tr>
				<td>	
					<c:choose>
					       <c:when test="${appreciationApply.courseState ne '2' && appreciationApply.paymentState ne '3' }">
					       		<input type="checkbox"    class="checkedId" applyId="${fns:escapeHtml(appreciationApply.id)}"/> 
					       </c:when>
					       <c:otherwise>
					       		<input type="checkbox"  onclick="return false;"  disabled  class="disabledCheckedId" applyId="${fns:escapeHtml(appreciationApply.id)}"/>
					       </c:otherwise>
					</c:choose>
					
					<%-- <c:if test="${appreciationApply.courseState ne '2' && appreciationApply.paymentState ne '3' }"> 
						<input type="checkbox"    class="checkedId" applyId="${fns:escapeHtml(appreciationApply.id)}"/> 
					</c:if>
					<c:if test="${appreciationApply.paymentState eq '3'  } ">
						<input type="checkbox"  onclick="return false;"  disabled  class="disabledCheckedId" applyId="${fns:escapeHtml(appreciationApply.id)}"/> 
					</c:if> --%>
				</td>
					
				<td>
					${fns:escapeHtml(appreciationApply.applyCode)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.applyChannel)}
				</td>
				<td>
					 <fmt:formatDate value="${appreciationApply.paymentTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.memberCardType)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.memberName)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.mobile)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.shopName)}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.province)} ${fns:escapeHtml(appreciationApply.city)}  ${fns:escapeHtml(appreciationApply.area)}
				</td>
				<td>
					${fns:getDictLabel(appreciationApply.paymentState, 'user_payment_state', '')}  ${appreciationApply.applyTypeDesc }
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.courseName)}
				</td>
				<td>
					${fns:getDictLabel(appreciationApply.courseState, 'appreciation_courses_state', '')}
				</td>
				<td>
					${fns:escapeHtml(appreciationApply.certificateCode)}
				</td>
				
				<shiro:hasPermission name="appreciation:appreciationApply:edit">
				<td>
					
						<c:if test="${appreciationApply.courseState ne '2' && appreciationApply.paymentState ne '3'}">
							<a href="###" onclick="arrange( '${appreciationApply.id}'  )">排课</a>
						</c:if>
						
						<c:if test="${not empty appreciationApply.courseId && !(appreciationApply.courseState eq '2')}">
							<a href="${ctx}/appreciation/appreciationApply/clean?id=${appreciationApply.id}" onclick="return confirmx('确认要解绑课程吗？', this.href)">解绑课程</a>
						</c:if>
						<a href="###" onclick="editAddress( '${appreciationApply.id}' )">编辑</a>
						
						<!-- 导入数据可以删除 -->
						<c:if test="${appreciationApply.applyChannel ne '个人'  &&   empty appreciationApply.courseId }">
						<a href="${ctx}/appreciation/appreciationApply/delete?id=${appreciationApply.id}" onclick="return confirmx('确认要删除报名记录吗？', this.href)">删除</a>
						</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>



<script>

</script>

</html>