/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 配种证明Controller
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Controller
@RequestMapping(value = "/subSystem/dogNewborn")
public class SubDogNewbornController extends BaseController {

	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogNewborn get(@RequestParam(required=false) String id) {
		DogNewborn entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogNewbornService.get(id);
		}
		if (entity == null){
			entity = new DogNewborn();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogNewborn dogNewborn, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogNewborn> page = dogNewbornService.findPage(new Page<DogNewborn>(request, response), dogNewborn); 
		model.addAttribute("page", page);
			return "subSystem/"+getUrlByUserType()+"/dog/dognewborn/dogNewbornList";
	}
	@RequestMapping(value = "form")
	public String form(DogNewborn dogNewborn, Model model) {
		model.addAttribute("dogNewborn", dogNewborn);
		return "subSystem/"+getUrlByUserType()+"/dog/dognewborn/dogNewbornView";
	}

}