/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.util.RequestUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 新生犬登记Controller
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "/subSystem/dogChip")
public class SubDogChipController extends BaseController {

	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogService dogService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogChip get(@RequestParam(required=false) String id) {
		DogChip entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogChipService.get(id);
		}
		if (entity == null){
			entity = new DogChip();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogChip dogChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		if(!RequestUtil.hasParameter(request)){
			//没有参数的查询，默认只查询最近的三个月
			Calendar calendar = Calendar.getInstance();//日历对象
			Date date = new Date();
			date.setHours(0);
			date.setMinutes(0);
			date.setSeconds(0);
			calendar.setTime(date);//设置当前日期
			calendar.add(Calendar.MONTH, -3);//年份+1
			dogChip.setCreateDate(calendar.getTime());
		}
		Page<DogChip> page = dogChipService.findPage(new Page<DogChip>(request, response), dogChip);
		for(DogChip po:page.getList()){
			po.setBusinessState(dogChipService.getBusinessState(po));
		}
		model.addAttribute("page", page);
		if(!RequestUtil.hasParameter(request)){
			dogChip.setCreateDate(null);
		}
		return "subSystem/"+getUrlByUserType()+"/dog/newdogchip/dogChipList";
	}

    @RequestMapping(value = "view")
    public String view(DogChip dogChip, Model model) {
        model.addAttribute("dogChip", dogChip);
        return "subSystem/"+getUrlByUserType()+"/dog/newdogchip/dogChipView";
    }


}