package com.cku.schools.mrschool.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

import net.sf.json.JSONObject;

@Controller
@RequestMapping("/schools/file")
public class SchoolsFileController extends BaseController {
	@Autowired
	private FileService fileService;
	
	@RequestMapping(value="/uploadPage")
	public String uploadPage(HttpServletRequest request,HttpServletResponse response){
		return "schools/upload";
	}
	
	/**
	 * 上传用户的头像
	 * @param file
	 * @param module
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value="avatar")
	@ResponseBody
    public void avatar(MultipartFile file,@RequestParam(value="module") String module,HttpServletResponse response) throws IOException
    {
		BaseFile baseFile = fileService.uploadFile(file,module,"0");
		JSONObject object = new JSONObject();
		object.put("fileName", baseFile.getName());
		object.put("id", baseFile.getId());
		//System.out.println("图片上传会返回的id>>>>>>>>>>>>>>>>>>>>>>>>："+baseFile.getId());
		RESTResponse result = new RESTResponse("data",object.toString());
		ServletUtils.writeResponse(response, result);
    }
	
	@RequestMapping(value="image/{id}")
	@ResponseBody
	public void image(@PathVariable String id,HttpServletResponse response) throws IOException{
		response.setContentType("application/octet-stream");
		fileService.fileDownload(id,response.getOutputStream());
	}
	
	/**
	 * 
	 * @Description：获取图片（合作学校使用）
	 * @author: 
	 * @version: 2016年12月16日 下午2:21:15
	 */
	@RequestMapping(value="image/cab")
	@ResponseBody
	public void image(HttpServletRequest request ,HttpServletResponse response) throws IOException{
		String id = request.getParameter("id");
		response.setContentType("application/octet-stream");
		fileService.fileDownload(id,response.getOutputStream());
	}
	
	@RequestMapping(value = "upload")
	@ResponseBody
	public void upload(MultipartFile file, @RequestParam(value = "module") String module, @RequestParam(value = "state") String state, HttpServletResponse response)
			throws IOException {
		if(StringUtils.isBlank(state)){
			state = "0";
		}
		BaseFile baseFile = fileService.uploadFile(file, module, state);
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.toString());
	}
	
}
