package com.cku.schools.mrschool.web;

import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.service.GroomerCourseApplicationService;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.schools.mrschool.service.OSSUtils;
import com.cku.schools.mrschool.service.SchoolsCourseService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 合作学校课程 user chaixueteng 2017年6月19日
 */
@Controller
@RequestMapping(value = "/schools/schoolsCourse")
public class SchoolsCourseController extends BaseController {

	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private SchoolsCourseService schoolsCourseService;
	@Autowired
	private FileService fileService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;
	@Autowired
	private GroomerCourseApplicationService groomerCourseApplicationService;

	@ModelAttribute
	public GroomerCourse get(@RequestParam(required = false) String id) {
		GroomerCourse entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerCourseService.get(id);
		}
		if (entity == null) {
			entity = new GroomerCourse();
		}
		return entity;
	}

	@RequestMapping(value = { "list", "" })
	public String list(GroomerCourse groomerCourse, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		String id = trainingInstitution.getId();
		groomerCourse.setSchoolId(id);
		Page<GroomerCourse> page = groomerCourseService.findPage(new Page<GroomerCourse>(request, response),
				groomerCourse);
		List<GroomerCourse> list = page.getList();
		for (GroomerCourse groomerCourse2 : list) {
			String id2 = groomerCourse2.getId();
			String haveDiploma = groomerDiplomaService.haveDiploma(id2);
			groomerCourse2.setHavaDiploma(haveDiploma);
		}
		model.addAttribute("page", page);
		return "schools/mrschool/groomerCourseList";
	}

	/**
	 * 添加课程
	 *
	 * @Author chaixueteng
	 * @2017年6月19日下午5:25:10
	 */
	@RequestMapping(value = "groomerCourseForm")
	public String groomerCourseForm(GroomerCourse groomerCourse, Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		model.addAttribute("trainingInstitution", trainingInstitution);
		model.addAttribute("groomerCourse", groomerCourse);
		List<TeacherLecturer> list = schoolsTeacherDao.findTeacherBySchoolId(trainingInstitution.getId());
		list.stream().map(data -> {
			data.setTeacherName(data.getTeacherName() + "(" + data.getTeacherIndex() + ")");
			return data;
		}).collect(Collectors.toList());
		model.addAttribute("teacherList", list);
		return "schools/mrschool/groomerCourseForm";
	}

	@RequestMapping(value = "groomerCourseEditForm")
	public String groomerCourseEditForm(GroomerCourse groomerCourse, Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		if (StringUtils.isNotBlank(groomerCourse.getIntroduce())) {
			String[] split = groomerCourse.getIntroduce().split(",");
			if (split.length == 3) {
				groomerCourse.setPic1(split[0]);
				groomerCourse.setPic2(split[1]);
				groomerCourse.setPic3(split[2]);
			} else if (split.length == 2) {
				groomerCourse.setPic1(split[0]);
				groomerCourse.setPic2(split[1]);
			} else if (split.length == 1) {
				groomerCourse.setPic1(split[0]);
			}
		}
		if (StringUtils.isNotBlank(groomerCourse.getVideo())) {
			groomerCourse.setVideoUrl(OSSUtils.getVodUrl(groomerCourse.getVideo()));
		}
		if (StringUtils.isNotBlank(groomerCourse.getCourseDetails())) {
			groomerCourse.setCourseDetails(StringEscapeUtils.unescapeHtml4(groomerCourse.getCourseDetails()));
		}
		model.addAttribute("trainingInstitution", trainingInstitution);
		model.addAttribute("groomerCourse", groomerCourse);
		List<TeacherLecturer> list = schoolsTeacherDao.findTeacherBySchoolId(trainingInstitution.getId());
		list.stream().map(data -> {
			data.setTeacherName(data.getTeacherName() + "(" + data.getTeacherIndex() + ")");
			return data;
		}).collect(Collectors.toList());
		model.addAttribute("teacherList", list);
		return "schools/mrschool/groomerCourseEditForm";
	}

	@RequestMapping(value = "onOffStates")
	public String onOffStates(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes) {

		schoolsCourseService.onOffStates(groomerCourse);
		addMessage(redirectAttributes, "保存美容课程成功");
		return "redirect:/schools/schoolsCourse/?repage";
	}

	/**
	 * 保存课程
	 *
	 * @throws Exception
	 * @Author chaixueteng
	 * @2017年6月20日下午2:21:59
	 */
	@RequestMapping(value = "save")
	public String save(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes)
			throws Exception {
		if (!beanValidator(model, groomerCourse)) {
			return groomerCourseForm(groomerCourse, model);
		}
		schoolsCourseService.save(groomerCourse);
		addMessage(redirectAttributes, "保存美容课程成功");
		return "redirect:/schools/schoolsCourse/?repage";
	}

	@RequestMapping(value = "saveEdit")
	public String saveEdit(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes)
			throws Exception {

		if ("1".equals(groomerCourse.getStates())) {
			groomerCourse.setStates("5");
		}
		schoolsCourseService.save(groomerCourse);
		addMessage(redirectAttributes, "保存美容课程成功");
		return "redirect:/schools/schoolsCourse/?repage";
	}

	/**
	 * 删除课程
	 *
	 * @Author chaixueteng
	 * @2017年6月20日下午2:21:51
	 */
	@RequestMapping(value = "delete")
	public String delete(GroomerCourse groomerCourse, RedirectAttributes redirectAttributes) {
		groomerCourseService.delete(groomerCourse);
		addMessage(redirectAttributes, "删除美容课程成功");
		return "redirect:/schools/schoolsCourse/?repage";
	}

	/**
	 * 课程结业申报列表
	 *
	 * @Author chaixueteng
	 * @2017年6月21日上午10:28:25
	 */
	@RequestMapping(value = "diplomaList")
	public String diplomaList(GroomerDiploma groomerDiploma, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		String id = trainingInstitution.getId();
		groomerDiploma.setSchoolId(id);
		Page<GroomerDiploma> page = groomerDiplomaService.findPage(new Page<GroomerDiploma>(request, response),
				groomerDiploma);
		model.addAttribute("page", page);
		return "schools/mrschool/groomerDiplomaList";
	}

	@RequestMapping(value = "viewApply")
	public String viewApply(GroomerCourseApplication groomerCourseApplication, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		groomerCourseApplication.setSchoolId(trainingInstitution.getId());
		Page<GroomerCourseApplication> page = groomerCourseApplicationService
				.findPage(new Page<GroomerCourseApplication>(request, response), groomerCourseApplication);
		List<GroomerCourseApplication> list = page.getList();
		List<GroomerCourseApplication> result = list.stream().filter(a -> "2".equals(a.getPaymentState()))
				.collect(Collectors.toList());
		page.setList(result);
		model.addAttribute("page", page);
		model.addAttribute("groomerCourseApplication", groomerCourseApplication);
		if (StringUtils.isBlank(groomerCourseApplication.getCourseId())) {
			return "schools/mrschool/courseApplyList";
		} else {
			return "schools/mrschool/courseApplyOneList";
		}
	}

	@RequestMapping(value = "groomerCourseApplicationDetail")
	public String groomerCourseApplicationDetail(String id, Model model) {
		GroomerCourseApplication groomerCourseApplication = groomerCourseApplicationService.get(id);
		GroomerCourse groomerCourse = groomerCourseService.get(groomerCourseApplication.getCourseId());
		model.addAttribute("groomerCourseApplication", groomerCourseApplication);
		model.addAttribute("groomerCourse", groomerCourse);
		return "schools/mrschool/groomerCourseApplicationDetail";
	}

	/**
	 * 添加结业记录
	 *
	 * @Author chaixueteng
	 * @2017年6月19日下午5:25:10
	 */
	@RequestMapping(value = "diplomaAdd")
	public String diplomaAdd(GroomerDiploma groomerDiploma, Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		String schoolId = trainingInstitution.getId();
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setSchoolId(schoolId);
		List<GroomerCourse> findCourseList = groomerCourseService.findCourseList(groomerCourse);
		model.addAttribute("findList", findCourseList);
		model.addAttribute("schoolId", schoolId);
		model.addAttribute("schoolNameCn", trainingInstitution.getSchoolNameCn());
		model.addAttribute("schoolNameEn", trainingInstitution.getSchoolNameEn());
		return "schools/mrschool/groomerDiplomaAdd";
	}

	/**
	 * 单条添加结业记录
	 *
	 * @Author chaixueteng
	 * @2017年6月23日上午10:51:47
	 */
	@RequestMapping(value = "diplomaSave")
	public String batchSave(GroomerDiploma groomerDiploma, Model model, HttpServletRequest request,
			HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			String avatar = request.getParameter("avatar");
			groomerDiplomaService.diplomaSave(groomerDiploma, avatar);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:/schools/schoolsCourse/diplomaAdd";
		}
		addMessage(redirectAttributes, "保存结业记录成功");
		return "redirect:/schools/schoolsCourse/diplomaList?repage";
	}

	/**
	 * 编辑单条添加结业记录
	 *
	 * @Author chaixueteng
	 * @2017年6月23日上午10:51:47
	 */
	@RequestMapping(value = "diplomaEditSave")
	public String diplomaEditSave(GroomerDiploma groomerDiploma, Model model, HttpServletRequest request,
			HttpServletResponse response, RedirectAttributes redirectAttributes) {
		groomerDiplomaService.diplomaEditSave(groomerDiploma);
		addMessage(redirectAttributes, "保存结业记录成功");
		return "redirect:/schools/schoolsCourse/diplomaList?repage";
	}

	/**
	 * 编辑结业记录
	 *
	 * @Author chaixueteng
	 * @2017年6月23日下午1:35:27
	 */
	@RequestMapping(value = "editForm")
	public String editForm(GroomerDiploma groomerDiploma, Model model) {
		String id = groomerDiploma.getId();
		GroomerDiploma groomerDiploma2 = groomerDiplomaService.get(id);
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setSchoolId(groomerDiploma2.getSchoolId());
		List<GroomerCourse> findCourseList = groomerCourseService.findCourseList(groomerCourse);
		model.addAttribute("findList", findCourseList);
		model.addAttribute("groomerDiploma", groomerDiploma2);
		return "schools/mrschool/groomerDiplomaEditForm";
	}

	/**
	 * 删除结业记录
	 *
	 * @Author chaixueteng
	 * @2017年6月23日下午1:35:27
	 */
	@RequestMapping(value = "deleteDiploma")
	public String deleteDiploma(GroomerDiploma groomerDiploma, Model model, RedirectAttributes redirectAttributes) {
		groomerDiplomaService.delete(groomerDiploma);
		addMessage(redirectAttributes, "删除结业记录成功");
		return "redirect:/schools/schoolsCourse/diplomaList?repage";
	}

	/**
	 * 查询课程信息
	 *
	 * @Author chaixueteng
	 * @2016年10月23日下午2:27:00
	 */
	@RequestMapping("rockMsg")
	@ResponseBody
	public Object rockMsg(HttpServletRequest request, HttpServletResponse response) {
		String id = request.getParameter("id");
		return schoolsCourseService.rockMsg(id);
	}

	/**
	 * 结业证书打印
	 *
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:16
	 */
	@RequestMapping(value = "groomerDiplomaPrint")
	public String groomerDiplomaPrint(String id, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		GroomerDiploma groomerDiploma = groomerDiplomaService.get(id);
		GroomerDiploma gd = schoolsCourseService.print(groomerDiploma);
		model.addAttribute("groomerDiploma", gd);
		return "schools/mrschool/groomerDiplomaPrint";
	}

	@RequestMapping(value = "layupload")
	@ResponseBody
	public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "groomerCourse", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path
				+ "/api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}

	/**
	 * 富文本编辑器上传
	 *
	 * @Author chaixueteng
	 * @2017年8月7日上午10:01:37
	 */
	@RequestMapping(value = "editorUpload")
	@ResponseBody
	public void editorUpload(@RequestParam MultipartFile editorImg, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		BaseFile baseFile = fileService.uploadFile(editorImg, "ShowPic", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path
				+ "/api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.getString("url"));
	}

	@RequestMapping("uploadAlyiVideo")
	@ResponseBody
	public Object uploadAlyiVideo(@RequestParam MultipartFile videoFile, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// 返回上传视频id
		JSONObject jo = new JSONObject();
		String videoId = OSSUtils.upload(videoFile);
		String vodUrl = OSSUtils.getVodUrl(videoId);
		jo.put("videoId", videoId);
		jo.put("videoUrl", vodUrl);
		return jo;
	}

	@RequestMapping("getStsToken")
	@ResponseBody
	public AssumeRoleResponse getStsToken(HttpServletRequest request, HttpServletResponse response) throws Exception {
		// 返回上传视频id
		AssumeRoleResponse assumeRoleResponse = OSSUtils.getStsToken();
		return assumeRoleResponse;
	}
	@RequestMapping("getVideoUrl")
	@ResponseBody
	public Object getVideoUrl(HttpServletRequest request, HttpServletResponse response,String name) throws Exception {
		String vodUrl = OSSUtils.getVodUrl(name);
		JSONObject jo = new JSONObject();
		jo.put("videoUrl", vodUrl);
		return jo;
	}
}
