package com.cku.schools.mrschool.web;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import com.cku.logUtil.JSONObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping("/schools/schoolsGroomer")
public class SchoolGroomerController extends BaseController {

	@Autowired
	private GroomerShowService groomerShowService;

	@Autowired
	private GroomerShowRefereeService showRefereeService;

	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;

	@Autowired
	private MemberService memberService;

	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@ModelAttribute
	public GroomerShow get(@RequestParam(required = false) String id) {
		GroomerShow entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerShowService.get(id);
		}
		if (entity == null) {
			entity = new GroomerShow();
		}
		return entity;
	}

	@RequestMapping(value = "/groomerShowList")
	public String account(GroomerShow groomerShow, Model model, HttpServletRequest request,
						  HttpServletResponse response) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		groomerShow.setSchools(ti.getId());
		groomerShow.setRegisterType("school");

		Page<GroomerShow> page = groomerShowService.findPage(new Page<GroomerShow>(request, response),
				groomerShow);
		request.setAttribute("date", new Date());

		model.addAttribute("page", page);
		return "schools/groomer/groomerShowList";
	}


	@RequestMapping(value = "view")
	public String view(GroomerShow groomerShow, Model model) throws ZAException {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findAllShowReferee();
		model.addAttribute("showRefereeList", showRefereeList);

		// 开放状态的合作学校
		TrainingInstitution ti = new TrainingInstitution();
		User user = new User();
		user.setLoginType("1");
		ti.setUser(user);
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("schools", findList);

		model.addAttribute("groomerShow", groomerShow);
		return "schools/groomer/groomerShowView";
	}


	@RequestMapping(value = "registerForm")
	public String registerForm(GroomerShow groomerShow, GroomerRegister groomerRegister, Model model) throws ZAException {
		model.addAttribute("groomerRegister", groomerRegister);
		model.addAttribute("groomerShow", groomerShow);
		model.addAttribute("groomerShowTypeMap", groomerShowService.getShowTypeMap(groomerShow.getShowCode()));
		return "schools/groomer/groomerShowRegisterForm";
	}

	@RequestMapping(value = "registerBatchForm")
	public String registerBatchForm(GroomerShow groomerShow, GroomerRegister groomerRegister, Model model) throws ZAException {
		logger.info("---------------groomerShow : {},----------------- : {}", JSONObjectUtils.toJsonString(groomerShow), JSONObjectUtils.toJsonString(groomerRegister));
		//查询该俱乐部下美容会员会员
		Member member = new Member();
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		logger.info("-------------------------------- : {}", JSON.toJSONString(trainingInstitution));
		member.setRegistrant(trainingInstitution.getUser().getName().trim());
		List<Member> groomerList;
		List<Member> targetList = null;
		//6为派多格资格证书
		if ("6".equals(groomerShow.getShowCategory())) {
			groomerList = memberService.findMemberListByRegistrant(member);
			if (!CollectionUtils.isEmpty(groomerList)) {
				Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());

				targetList = groomerList.stream()
						.filter(m -> m.getGroomerEndDate() != null)
						.filter(m -> m.getGroomerEndDate().compareTo(now) >= 0)
						.collect(Collectors.toList());
				//过滤已经报名该场赛活动的
				if (!CollectionUtils.isEmpty(targetList)) {
					List<GroomerRegister> groomerRegisterList = groomerRegisterService.findListByMember(targetList, groomerShow.getShowCode());
					targetList = targetList.stream()
							.filter(m -> groomerRegisterList.stream().noneMatch(gr -> gr.getMemberCode().equals(m.getMemberCode())))
							.collect(Collectors.toList());
				}
			}
		} if ("8".equals(groomerShow.getShowCategory())) {
			groomerList = memberService.findList(member);
			logger.info("-----伴侣猫可报名会员----- : {}", JSON.toJSONString(groomerList));
			if (!CollectionUtils.isEmpty(groomerList)) {
				Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
				/*//过滤已经有过伴侣猫资格证书的
				List<GroomerQualificationCertificate> certificateList = groomerQualificationCertificateService.findListByMember(groomerList);*/
				targetList = groomerList.stream()
						.filter(m -> m.getMemberEndDate() != null || m.getGroomerEndDate() != null)
						.filter(m -> m.getMemberEndDate().compareTo(now) >= 0
								|| m.getGroomerEndDate().compareTo(now) >= 0)
						/*.filter(m -> certificateList.stream()
								.filter(gqc -> "8".equals(gqc.getCertificateType()))
								.filter(gqc -> !StringUtils.isBlank(gqc.getCertificateCode()))
								//.filter(gqc -> groomerRegister.getShowLevel().equals(gqc.getLevelEn()))
								.noneMatch(gqc -> gqc.getMemberCode().equals(m.getMemberCode())))*/
						.collect(Collectors.toList());
				//过滤已经报名该场赛活动的
				if (!CollectionUtils.isEmpty(targetList)) {
					List<GroomerRegister> groomerRegisterList = groomerRegisterService.findListByMember(targetList, groomerShow.getShowCode());
					targetList = targetList.stream()
							.filter(m -> groomerRegisterList.stream().noneMatch(gr -> gr.getMemberCode().equals(m.getMemberCode())))
							.collect(Collectors.toList());
				}
			}
		} else {
			if ("4".equals(groomerShow.getShowCategory())) {
				groomerList = memberService.findList(member);
			} else {
				groomerList = memberService.findGroomerCertificateList(member);
			}

			if(!CollectionUtils.isEmpty(groomerList)) {
				//过滤已经有过资格证书的
				List<GroomerQualificationCertificate> certificateList = groomerQualificationCertificateService.findListByMember(groomerList);
				if ("4".equals(groomerShow.getShowCategory())) {
					Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
					//4是洗护师资格证书
					targetList = groomerList.stream()
							.filter(m -> m.getMemberEndDate() != null || m.getGroomerEndDate() != null)
							.filter(m -> m.getMemberEndDate().compareTo(now) >= 0
									|| m.getGroomerEndDate().compareTo(now) >= 0)
							.filter(m -> certificateList.stream()
									.filter(gqc -> "4".equals(gqc.getCertificateType()))
									.filter(gqc -> !StringUtils.isBlank(gqc.getCertificateCode()))
									.noneMatch(gqc -> gqc.getMemberCode().equals(m.getMemberCode())))
							.collect(Collectors.toList());
				} else {
					//其他资格证书
					targetList = groomerList.stream()
							.filter(m -> certificateList.stream()
									.filter(gqc -> !"4".equals(gqc.getCertificateType()))
									.noneMatch(gqc -> gqc.getMemberCode().equals(m.getMemberCode())))
							.collect(Collectors.toList());
				}
				//过滤已经报名该场赛活动的
				if (!CollectionUtils.isEmpty(targetList)) {
					List<GroomerRegister> groomerRegisterList = groomerRegisterService.findListByMember(groomerList, groomerShow.getShowCode());
					targetList = targetList.stream()
							.filter(m -> groomerRegisterList.stream().noneMatch(gr -> gr.getMemberCode().equals(m.getMemberCode())))
							.collect(Collectors.toList());
				}

			}
		}


		model.addAttribute("memberList", targetList);
		//报名信息
		groomerRegister.setShowCode(groomerShow.getShowCode());
		groomerRegister.setGroomerShowId(groomerShow.getId());
		model.addAttribute("groomerRegister", groomerRegister);
		//活动信息
		model.addAttribute("groomerShow", groomerShow);
		model.addAttribute("groomerShowTypeMap", groomerShowService.getShowTypeMap(groomerShow.getShowCode()));
		return "schools/groomer/groomerShowRegisterBatchForm";
	}


	@RequestMapping(value = "/getShowType")
	public void getShowType(HttpServletRequest request, HttpServletResponse response) {
		String showCode = request.getParameter("showCode");
		try {
			response.setContentType("text/Xml;charset=utf-8");
			String str = groomerShowService.getShowType(showCode);
			response.getWriter().write(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@RequestMapping(value = "/getShowMessage")
	public void getShowMessage(HttpServletRequest request, HttpServletResponse response) {
		String id = request.getParameter("id");
		try {
			response.setContentType("text/Xml;charset=utf-8");
			String str = groomerShowService.getShowMessage(id);
			response.getWriter().write(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
