/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.show.service;

import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowApplyService;

/**
 * 赛事报名表Service
 *
 * @author lgl
 * @version 2016-07-15
 */
@Service
@Transactional(readOnly = true)
public class RestShowApplyServiceV2 {
	@Autowired
	private DogService dogService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ShowApplyService showApplyService;

	public RESTResponse getAgeGroup(HttpServletRequest request) {
		// 获取参数
		String mainShowId = request.getParameter("mainShowId");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String groupType = request.getParameter("groupType");
		// 参数校验
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主赛事id为空");
		}
		if (StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		MainShows mainShows = mainShowsService.get(mainShowId);
		if (mainShows == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主赛事id有误");
		}
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		if (dog == null) {
			// 支持根据芯片号进行查询
			dog = dogService.getByIdentificationFlag(pedigreeCertified);
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或芯片号有误");
			}
		}
		if (dog.getBirthdate() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只出生日期为空，请完善后再报名");
		}
		JSONObject jo = showApplyService.getAgeGroupListString(mainShows.getId(), dog, groupType);
		JSONArray ageGroupArray = JSONArray.fromObject(JSON.toJSONString(jo.get("ageGroupArray")));
		JSONArray newAgeGroupArray = new JSONArray();
		for (int i = 0; i < ageGroupArray.size(); i++) {
			try {
				JSONObject jsonObject = ageGroupArray.getJSONObject(i);
				String childShowName = jsonObject.getString("childShowName");
				//有特殊符号，转成unicode编码,前端展示
				jsonObject.put("childShowName", StringEscapeUtils.unescapeHtml4(childShowName));
				newAgeGroupArray.add(jsonObject);
			} catch (Exception e) {
				System.err.println("第 " + i + " 个元素不是JSONObject: " + e.getMessage());
			}
		}
		jo.put("ageGroupArray", newAgeGroupArray);
		return new RESTResponse("data", jo);
	}

}