package com.cku.restful.v2.order.web;

import com.cku.core.ResultDto;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v2.order.service.RestOrderServiceV2;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.cku.restful.v2.order.vo.response.OrderApplyInfoResponse;
import com.cku.restful.v2.order.vo.response.OrderCommitResponse;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

/**
 * @author yuanshuai
 * @date 2023/6/15 15:36
 */
@Controller
@RequestMapping(value = "/api/v2/order")
@Api(tags = "订单接口V2")
public class RestOrderControllerV2 extends BaseRestController {

    @Autowired
    private RestOrderServiceV2 restOrderServiceV2;

    @ApiOperation(value = "下单前参数校验")
    @PostMapping(value = "/businessValidate")
    @ResponseBody
    public ResultDto<Boolean> businessValidate(@Valid @RequestBody OrderApplyRequest request) {
        System.out.println("-----------入参  : {}" + JSONObjectUtils.toJsonString(request));
        BeanValidators.validateWithException(validator, request);
        restOrderServiceV2.businessValidate(request);
        return ResultDto.success(Boolean.TRUE);
    }

    @ApiOperation(value = "下单前参数校验并根据业务ID和业务参数查询商品相关信息")
    @PostMapping(value = "/pre")
    @ResponseBody
    public ResultDto<OrderApplyInfoResponse> preOrder(@Valid @RequestBody OrderApplyRequest request) {
        BeanValidators.validateWithException(validator, request);
        OrderApplyInfoResponse resp = restOrderServiceV2.preOrder(request);
        return ResultDto.success(resp);
    }

    @ApiOperation(value = "提交订单")
    @PostMapping(value = "/commit")
    @ResponseBody
    public ResultDto<OrderCommitResponse> commitOrder(@Valid @RequestBody OrderApplyRequest request) {
        BeanValidators.validateWithException(validator, request);
        OrderCommitResponse resp = restOrderServiceV2.commitOrder(request);
        return ResultDto.success(resp);
    }

    @ApiOperation(value = "提交订单并余额支付")
    @PostMapping(value = "/commit/balancePay")
    @ResponseBody
    public ResultDto<OrderCommitResponse> commitOrderAndBalancePay(@Valid @RequestBody OrderApplyRequest request) {
        BeanValidators.validateWithException(validator, request);
        OrderCommitResponse resp = restOrderServiceV2.commitOrderAndBalancePay(request);
        return ResultDto.success(resp);
    }
}
