/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.restful.v1.dog.model.RestDogType;
import com.cku.restful.v1.sys.model.RestOrg;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;

/**
 * 合作机构Controller
 *
 * @author laiguanglong
 * @version 2017-07-13
 */
@Controller
@RequestMapping(value = "/cku/v1/org")
public class CkuOrgController extends BaseRestController {

	@Autowired
	private OrgDao orgDao;
	@Autowired
	private OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	private DogTypeService dogTypeService;

	/**
	 * @description: CKU官网合作机构查询接口 orgType:1为club；2为hospital
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午5:26:13
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getOrg(HttpServletRequest request, HttpServletResponse response) throws IOException {

		System.out.println("--------------------------" + IPLimitUtil.getIpAddr(request));

		// 获取参数 请检查KEY是否一致
		String orgTypeString = request.getParameter("orgType");
		// 犬种
		// String dogTypeId = request.getParameter("dogTypeId");
		String orgSite = request.getParameter("orgSite");// 1 2
		String province = request.getParameter("province");
		Integer pageNoInt = ServletUtils.getParameterInt(request, "pageNo", 1);// 页数
		Integer pageSizeInt = ServletUtils.getParameterInt(request, "pageSize", 10);// 页码
		String orgTypeS = "";
		if (StringUtils.isNotBlank(orgTypeString)) {
			String[] orgTypeStringArray = orgTypeString.split(",");
			StringBuilder sb = new StringBuilder();
			for (String orgType : orgTypeStringArray) {
				if ("1".equals(orgType)) {
					sb.append("'club',");
				} else if ("2".equals(orgType)) {
					sb.append("'hospital',");
				} else if ("3".equals(orgType)) {
					sb.append("'catRenZheng',");
				} else if ("4".equals(orgType)) {
					sb.append("'chongjihemendian',");
				} else if ("5".equals(orgType)) {
					sb.append("'singleTypeClub',");
				}
			}
			sb.deleteCharAt(sb.length() - 1);
			orgTypeS = "(" + sb.toString() + ")";
		}
		// 分页
		List<Org> orgList = orgDao.getOrg(orgTypeS, province, orgSite, (pageNoInt - 1) * pageSizeInt, pageSizeInt);
		// 查询所有记录条数
		List<Org> orgCountList = orgDao.getOrgList(orgTypeS, province, orgSite);
		// 组装返回数据
		List<RestOrg> list = new ArrayList<RestOrg>();
		for (Org org : orgList) {
			RestOrg vo = new RestOrg();
			BeanUtil.copyProperties(vo, org, "yyyy-MM-dd HH:mm");
			// 如果为单犬种俱乐部
			if (vo.getOrgType().equals("singleTypeClub")) {
				// 该俱乐部所有单犬种
				List<String> typeCnList = orgDogTypeLimitService.findTypeCnByOrgId(vo.getId());
				vo.setOrgSite( String.join(",", typeCnList));
			} else {
				// 可办理犬种
				if (StringUtils.isBlank(org.getOrgSite())) {
					vo.setOrgSite("全犬种（不包括玛利诺斯犬牧羊犬）");
				} else {
					String[] split = org.getOrgSite().split(",");
					if (split.length > 1) {
						vo.setOrgSite("全犬种 ");
					} else if (org.getOrgSite().equals("1")) {
						vo.setOrgSite("全犬种（不包括玛利诺斯犬牧羊犬）");
					} else {
						vo.setOrgSite("玛丽诺斯牧羊犬 ");
					}
				}
			}
			list.add(vo);
		}
		ServletUtils.writeResponse(response,
				new RESTResponse("data", new PageBeanResult<RestOrg>(list, (long) orgCountList.size())));
	}
}