package com.cku.restful.v1.sys.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.service.CkuMemberServide;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>
 * Title:CkuMemberController
 * </p>
 * <p>
 * Description:会员信息（CKU官网使用）
 * </p>
 * <p>
 * Company:
 * </p>
 * 
 * @author zhuoHeng
 * @date 2016年9月23日 下午6:55:38
 */
@Controller
@RequestMapping(value = "/cku/v1/member")
public class CkuMemberController extends BaseRestController {

	@Autowired
	public CkuMemberServide ckuMemberServide;

	/**
	 * 
	 * @Description：根据会员号/手机号获取会员信息（CKU官网使用）
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午6:56:07
	 * @throws IOException
	 */
	@RequestMapping(value = "/member", method = RequestMethod.GET)
	@ResponseBody
	public void getMember(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = ckuMemberServide.getMemberByMobile(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getInfoByCode", method = RequestMethod.GET)
	@ResponseBody
	public void getInfoByCode(HttpServletRequest request,
						  HttpServletResponse response) throws IOException {
		RESTResponse result = ckuMemberServide.getInfoByCode(request);
		ServletUtils.writeResponse(response, result);
	}
}
