/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.show.service.RestChampionLoginService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 冠军登录Controller
 * 
 * @author zhuoHeng
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "/api/v1/show")
public class RestChampionLoginController extends BaseRestController {

	@Autowired
	private RestChampionLoginService restChampionLoginService;

	@RequestMapping(value = "/championlogin", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restChampionLoginService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/championlogin", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restChampionLoginService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/championlogin/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restChampionLoginService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 上午11:16:55
	 */
	@RequestMapping(value = "/championlogin/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restChampionLoginService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

}