package com.cku.restful.v1.show.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.show.service.CkuChampionLoginService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:CkuChampionLoginController </p>
 * <p>Description: 冠军登录查询</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年9月23日 下午4:15:48
 */
@Controller
@RequestMapping(value = "/cku/v1/shows/championLogin")
public class CkuChampionLoginController extends BaseRestController{

	
	@Autowired
	private CkuChampionLoginService restChampionLoginService;
	/**
	 * 
	 * @Description：按冠军登录类型查询登录犬只数据（CKU官网使用）
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午3:40:51
	 */
	@RequestMapping(value = "/getChampionLogin",method = RequestMethod.GET)
	@ResponseBody
	public void getChampionLogin(HttpServletRequest request, HttpServletResponse response) throws IOException{
		String loginType = ServletUtils.getParameter(request, "loginType");//冠军登录类型
		String pedigreeCertifiedCode = ServletUtils.getParameter(request, "pedigreeCertifiedCode",null);//血统证书号
		Integer pageNo = ServletUtils.getParameterInt(request, "pageNo",null);//页数
		Integer pageSize = ServletUtils.getParameterInt(request, "pageSize",null);//页码
		RESTResponse result = restChampionLoginService.getChampionLogin(loginType,pedigreeCertifiedCode, null, pageNo,pageSize);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：按年度查询冠军登录的犬只+图片+犬舍信息
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午6:03:33
	 */
	@RequestMapping(value = "/championLogin",method = RequestMethod.GET)
	@ResponseBody
	public void championLogin(HttpServletRequest request, HttpServletResponse response) throws IOException{
		String loginType = ServletUtils.getParameter(request, "loginType");//冠军登录类型
		Integer pageNo = ServletUtils.getParameterInt(request, "pageNo",null);//页数
		Integer pageSize = ServletUtils.getParameterInt(request, "pageSize",null);//页码
		String annual = ServletUtils.getParameter(request, "annual",null);//年度
		RESTResponse result = restChampionLoginService.championLogin(loginType,pageNo,pageSize,annual);
		ServletUtils.writeResponse(response, result);
	}
}
