package com.cku.restful.v1.shop.service;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.shop.dao.ShopGoodsDao;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.service.ShopGoodsService;
import com.cku.restful.v1.shop.model.RestShopGoods;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;

/**
 * 商品管理Service
 * 
 * @author lyy
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestShopGoodsService {
	// @Autowired
	// private ShopGoodsClassDao shopGoodsClassDao;
	@Autowired
	private ShopGoodsService shopGoodsService;
	@Autowired
	private ShopGoodsDao shopGoodsDao;

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String name = request.getParameter("name");
		String classId = request.getParameter("classId");
		String buyGifts = request.getParameter("buyGifts");
		String isRebate = request.getParameter("isRebate");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		ShopGoods example = new ShopGoods();
		Page<ShopGoods> page = new Page<ShopGoods>();
		// 设置分页参数
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(name)) {
			example.setName(name);
		}
		if (StringUtils.isNotBlank(classId)) {
			example.setClassId(classId);
		}
		if (StringUtils.isNotBlank(buyGifts)) {
			example.setBuyGifts(buyGifts);
		}
		if (StringUtils.isNotBlank(isRebate)) {
			example.setIsRebate(isRebate);
		}
		// 查询并组装返回对象
		Page<ShopGoods> result = shopGoodsService.findPage(page, example);
		List<ShopGoods> shopGoodsList = result.getList();
		List<RestShopGoods> list = new ArrayList<RestShopGoods>();
		for (ShopGoods shopGoods : shopGoodsList) {
			RestShopGoods vo = new RestShopGoods();
			BeanUtil.copyProperties(vo, shopGoods, "yyyy-MM-dd");
			String buyGiftsString = null;
			if("0".equals(vo.getBuyGifts())){
				buyGiftsString = "";
			}else if("1".equals(vo.getBuyGifts())){
				buyGiftsString = "满5返1,满10返3";
			}else if("2".equals(vo.getBuyGifts())){
				buyGiftsString = "满10返2";
			}
			vo.setBuyGifts(buyGiftsString);
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestShopGoods>(list,
				count));
	}

	public RESTResponse get(String id) {
		ShopGoods shopGoods = shopGoodsService.get(id);
		if (shopGoods == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestShopGoods vo = new RestShopGoods();
		BeanUtil.copyProperties(vo, shopGoods, "yyyy-MM-dd");
		String buyGiftsString = null;
		if("0".equals(vo.getBuyGifts())){
			buyGiftsString = "";
		}else if("1".equals(vo.getBuyGifts())){
			buyGiftsString = "满5返1,满10返3";
		}else if("2".equals(vo.getBuyGifts())){
			buyGiftsString = "满10返2";
		}
		vo.setBuyGifts(buyGiftsString);
		return new RESTResponse("data", vo);
	}
	
	/**
	 * 
	 * @description: 获取商品可买赠商品列表
	 * @author: laiguanglong
	 * @date: 2016年10月23日 上午11:43:58
	 */
	public RESTResponse getBuyGifts(HttpServletRequest request) {
		// 获取参数
		String id = request.getParameter("id");
		if(StringUtils.isBlank(id)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品id为空");
		}
		ShopGoods shopGoods = shopGoodsService.get(id);
		if(shopGoods==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品id有误");
		}
		// 查询并组装返回对象
		List<ShopGoods> shopGoodsList = shopGoodsDao.getLessGoodsList(shopGoods.getPrice());
		List<RestShopGoods> list = new ArrayList<RestShopGoods>();
		for (ShopGoods sg : shopGoodsList) {
			RestShopGoods vo = new RestShopGoods();
			BeanUtil.copyProperties(vo, sg, "yyyy-MM-dd");
			String buyGiftsString = null;
			if("0".equals(vo.getBuyGifts())){
				buyGiftsString = "";
			}else if("1".equals(vo.getBuyGifts())){
				buyGiftsString = "满5返1,满10返3";
			}else if("2".equals(vo.getBuyGifts())){
				buyGiftsString = "满10返2";
			}
			vo.setBuyGifts(buyGiftsString);
			list.add(vo);
		}
		long count = shopGoodsList.size();
		return new RESTResponse("list", new PageBeanResult<RestShopGoods>(list,
				count));
	}

}