/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.kennel.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.utils.StringUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * 犬舍基本信息Service
 * @author fanhuibin
 * @version 2016-07-13
 */
@Service
@Transactional(readOnly = true)
public class RestStarKennelService {

	@Autowired
	public PaymentOrderDao paymentOrderDao;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public DogDao dogDao;
	@Autowired
	public ShowApplyDao showApplyDao;
	@Autowired
	public DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	public DogChipDao dogChipDao;
	@Autowired
	private KennelDao kennelDao;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private MemberDao memberDao;
	/**
	 * @description: 处理NULL属性转空字符串的方法
	 * @author: laiguanglong
	 * @date: 2017/2/16 12:15
	 */
	public static String nullToEmptyString(String s){
		return s==null?"":s;
	}
	/**
	 *
	 * @description: 星级犬舍联盟申请条件校验的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午3:20:26
	 */
	public RESTResponse applyCheck(HttpServletRequest request){
		//参数检查
		String memberCode = request.getParameter("memberCode");
		if(StringUtils.isBlank(memberCode)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"会员号为空");
		}

		//默认不通过
		boolean check1 = false;
		boolean check2 = false;
		boolean check3 = false;

		//要求当前会员为CKU专业会员且会员有效
		Member member = memberDao.getByMemberCode(memberCode);
		//有犬舍，且犬舍在有效期内
		Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
		if (MemberUtil.isActiveMember(member)
				&& MemberUtil.isProfessionalMember(member)
				&& kennel != null
				&& "1".equals(kennel.getReviewState())
				&& kennel.getEndTime() != null
				&& kennel.getEndTime().getTime() > System.currentTimeMillis()) {
			check1 = true;
		}

		//名下犬只数量
        int dogCount = dogDao.countByMemberCode(memberCode);
        if (dogCount >= 5) {
            check2 = true;
        }

        //年度参赛次数
        int showApplyCount = showApplyDao.countByMemberCodeCurrentYear(memberCode);
        //年度申请出生纸
        int dogBirthCertificateCount = dogBirthCertificateDao.countByBreederMemberCodeCurrentYear(memberCode);
        //年度申请血统证书
        int dogChipCount = dogChipDao.countByBreederMemberCodeCurrentYear(memberCode);
        //年度参赛数大于等于10
        if (showApplyCount >= 10) {
            check3 = true;
        }
        //犬舍核算状态为已通过，且申请血统书≥4
        if (kennel != null
				&& "1".equals(kennel.getCalculationState())
				&& dogChipCount >= 4) {
            check3 = true;
        }
		//犬舍核算状态为待核算或免核算,申请日之前一年内的出生纸申请数量≥10 且申请血统书≥4
        if (kennel != null
                && ("0".equals(kennel.getCalculationState()) || "3".equals(kennel.getCalculationState()))
                && dogBirthCertificateCount >= 10
				&& dogChipCount >= 4) {
            check3 = true;
        }

		JSONObject jo = new JSONObject();
		jo.put("check1",check1);
		jo.put("check2",check2);
		jo.put("check3",check3);
		return new RESTResponse("data",jo);
	}
	/**
	 *
	 * @description: 星级犬舍联盟根据城市和关键字查询俱乐部信息的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午3:20:26
	 */
	public RESTResponse getClubByCityAndKey(HttpServletRequest request){
		//获取城市和关键字参数
		String city = request.getParameter("city");
		String key = request.getParameter("key");
		//初始化返回值
		TreeMap treeMap = new TreeMap<String,JSONArray>();
		List<Org> orgList = orgDao.getByCityAndKey(city,key);
		for(Org org:orgList){
			//分组
			if(StringUtils.isNotBlank(org.getName())){
				String firstAlphabet = getFirstAlphabet(org.getName());
				JSONArray value = (JSONArray)treeMap.get(firstAlphabet);
				if(value == null){
					JSONArray array = new JSONArray();
					array.add(buildOrgJSONObject(org));
					treeMap.put(firstAlphabet,array);
				}else{
					value.add(buildOrgJSONObject(org));
				}
			}
		}
		//从新组装
		JSONArray result = new JSONArray();
		Iterator<Map.Entry<String, JSONArray>> it = treeMap.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry<String, JSONArray> entry = it.next();
			JSONObject jo = new JSONObject();
			jo.put("category",entry.getKey());
			jo.put("info",entry.getValue());
			result.add(jo);
		}
		return new RESTResponse("data",result);
	}

	/**
	 * @description: 获取字符串首字符拼音首字母
	 * @author: laiguanglong
	 * @date: 2017/2/17 14:43
	 */
	private String getFirstAlphabet(String s){
		String firstChar = s.substring(0,1);
		if(firstChar.matches("[a-zA-Z]+")){
			return firstChar.toUpperCase();
		}else{
			return PinyinHelper.toHanyuPinyinStringArray(s.toCharArray()[0])[0].toUpperCase().substring(0,1);
		}
	}

	/**
	 * @description: 构建返回的俱乐部信息
	 * @author: laiguanglong
	 * @date: 2017/2/17 14:44
	 */
	private JSONObject buildOrgJSONObject(Org org){
		JSONObject jo = new JSONObject();
		jo.put("id",org.getId());
		jo.put("name",org.getName());
		jo.put("address",org.getAddress());
		return jo;
	}

	/**
	 *
	 * @description: CKU官网根据会员号查询犬舍信息的接口
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午3:20:26
	 */
	public RESTResponse getKennelByMemberCode(HttpServletRequest request){
		String memberCode = request.getParameter("memberCode");
		if(StringUtils.isBlank(memberCode)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"会员号为空");
		}
		Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
		if(kennel==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该会员没有犬舍");
		}
		if(kennel.getEndTime().getTime()<System.currentTimeMillis()){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该会员已过期");
		}
		JSONObject jo = new JSONObject();
		jo.put("name",nullToEmptyString(kennel.getName()));
		jo.put("member.name",nullToEmptyString(kennel.getMember().getName()));
		jo.put("member.province",nullToEmptyString(kennel.getMember().getProvince()));
		jo.put("member.city",nullToEmptyString(kennel.getMember().getCity()));
		jo.put("member.street",nullToEmptyString(kennel.getMember().getStreet()));
		jo.put("member.phone",nullToEmptyString(kennel.getMember().getPhone()));
		jo.put("member.mobile",nullToEmptyString(kennel.getMember().getMobile()));
		return new RESTResponse("data",jo);
	}

}