package com.cku.restful.v1.groomer.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerQualificationCertifiCateService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 美容师资格证书Controller
 * @author cxt
 * @version 2016-07-22
 */
@Controller
@RequestMapping(value = "/api/v1/groomerQualificationCertificate")
public class RestGroomerQualificationCertificateController extends BaseRestController {
	
	@Autowired
	public RestGroomerQualificationCertifiCateService restGroomerQualificationCertifiCateService;
	
	/**certificateList
	 * 查询是否符合领取胸花
	 * @throws Exception 
	 * @Author chaixueteng
	 * @2016年9月21日下午8:04:13
	 */
	@RequestMapping(value = "/reveive", method = RequestMethod.GET)
	@ResponseBody
	public void reveiveCorsage(HttpServletRequest request,HttpServletResponse response) throws Exception {
		RESTResponse result = restGroomerQualificationCertifiCateService.reveiveCorsage(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 返回会员信息
	 * @throws Exception 
	 * @Author chaixueteng
	 * @2016年9月21日下午8:04:13
	 */
	@RequestMapping(value = "/memberMsg", method = RequestMethod.GET)
	@ResponseBody    
	public void memberMsg(HttpServletRequest request,HttpServletResponse response) throws Exception {
		RESTResponse result = restGroomerQualificationCertifiCateService.memberMsg(request);
		ServletUtils.writeResponse(response, result);
	}
}