/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dogNoseprin.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.restful.v1.dogNoseprin.entity.DogPrizePool;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 奖池设置表DAO接口
 * 
 * @author xx
 * @version 2020-05-07
 */
@MyBatisDao
public interface DogPrizePoolDao extends CrudDao<DogPrizePool> {
	List<DogPrizePool> findListByPoolCode(@Param("poolCode") String poolCode);

	DogPrizePool getByPrizeName(@Param("poolCode") String poolCode, @Param("prizeName") String prizeName);

	int deduct(@Param("id") String id, @Param("num") Integer num);
}