package com.cku.restful.v1.dogNose.model;

import java.io.Serializable;

import com.cku.restful.v1.dogNose.enums.NoseCheckinBizTypeEnum;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class RestDogNoseCheckinRequest implements Serializable {

	private static final long serialVersionUID = -4902012884022640073L;

	@ApiModelProperty(value = "业务ID")
	private String bizId;
	
	@ApiModelProperty(value = "业务类型 10：出生纸，20：血统证书，30：血统证书整窝，40：犬只补录，50：视频鉴定，60：宠爱护照")
	private NoseCheckinBizTypeEnum bizType;
	
	@ApiModelProperty(value = "是否是俱乐部")
	private Boolean clubFlag = Boolean.FALSE;
	
	@ApiModelProperty(value = "手机平台")
	private Device device;
	
	@Data
	@ApiModel
	public class Device implements Serializable {
		
		private static final long serialVersionUID = 1954179370081688620L;

		@ApiModelProperty(value = "设备号 HONORMOA-AL20,MT162CH/A")
		private String number;
		
		@ApiModelProperty(value = "设备平台 例如 Android IOS")
		private String platform;

		@ApiModelProperty(value = "设备型号 例如：Android：MOA-AL20；IOS：XS，XR")
		private String model;
		
		@ApiModelProperty(value = "设备系统版本 例如：Android：29，30；IOS：13.1，14.2")
		private String version;
		
		@ApiModelProperty(value = "设备其他信息")
		private String information;
		
	}
}
