package com.cku.restful.v1.dog.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.model.CkuShowsResults;
import com.cku.restful.v1.dog.service.CkuShowsResultsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:RestDogResultsController </p>
 * <p>Description: CKU官网犬只成绩积分查询</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年9月23日 下午1:49:30
 */
@Controller
@RequestMapping(value = "cku/v1/showsResults")
public class CkuShowsResultsController extends BaseRestController{
	
	@Autowired
	public CkuShowsResultsService restShowsResultsService;

	/**
	 * 
	 * @Description：
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午1:49:40
	 * @throws IOException 
	 */
	@RequestMapping(value = "/dogResults",method = RequestMethod.GET)
	public void getDogResults(HttpServletRequest request, HttpServletResponse response) throws IOException{
		RESTResponse result = null;
		try {
			String pedigreeCertifiedCode = ServletUtils.getParameter(request, "pedigreeCertifiedCode",null);//血统证书号
			Integer pageNo = ServletUtils.getParameterInt(request, "pageNo",null);//页数
			Integer pageSize = ServletUtils.getParameterInt(request, "pageSize",null);//页码
			String ageGroup = ServletUtils.getParameter(request, "ageGroup",null);//年龄组别
			String annual = ServletUtils.getParameter(request, "annual");//年度
			List<CkuShowsResults> mainShowsList = restShowsResultsService.getShowsResult(pedigreeCertifiedCode,pageNo,pageSize,ageGroup,annual);
			result = new RESTResponse("list",new PageBeanResult<CkuShowsResults>(mainShowsList,(long)mainShowsList.size()));
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}
