package com.cku.restful.v1.dog.vo;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel
@Data
public class DogNoseResultAddRecordVo {

	@ApiModelProperty(value = "犬只芯片号")
	@NotNull(message = "犬只芯片号不能为空")
	private String dogChip;

	@ApiModelProperty(value = "鼻纹编号")
//	@NotNull(message = "鼻纹编号不能为空")
	private String dogNose;

	@ApiModelProperty(value = "识别类型 1: 1:1识别 2 1:N识别")
	@NotNull(message = "识别类型不能为空")
	private String noseType;

	@ApiModelProperty(value = "设备类型 IOS / Android")
	private String deviceType;

	@ApiModelProperty(value = "设备信息 例 iphone 8 / vivo s7e")
	private String deviceModel;

	@ApiModelProperty(value = "识别结果 0:成功 1:失败")
	@NotNull(message = "识别结果不能为空")
	private String noseResult; 

	@ApiModelProperty(value = "1:N详情 top1:123456;top2:45678;top3:123444")
	private String noseResultInfo; 
	
	@ApiModelProperty(value = "成功次序 top1 top2 top3")
	private String successSort; // 1:n 信息
	
}
