/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.model;

import com.cku.oa.dog.entity.DogType;
import com.thinkgem.jeesite.common.utils.StringUtils;
import net.sourceforge.pinyin4j.PinyinHelper;

/**
 * 犬只种类Entity
 *
 * @author zhuoHeng
 * @version 2016-07-21
 */
public class RestDogType {
    private String id;
    private String dogBreedCode;        // 犬种类代码
    private String breedCnName;        // 犬种类中文名称
    private String pinyin;        // 犬种类中文名称首汉字拼音
    private String dogBreed;        // 犬种类代码
    public RestDogType(DogType dogType) {
        this.id = dogType.getId();
        this.dogBreedCode = dogType.getDogBreedCode();
        this.dogBreed = dogType.getDogBreedCode();
        this.breedCnName = dogType.getBreedCnName();
        if(StringUtils.isNotBlank(dogType.getBreedCnName())){
            String[] array = PinyinHelper.toHanyuPinyinStringArray(dogType.getBreedCnName().charAt(0));
            if(array!=null){
                this.pinyin = array[0].toString();
            }
        }
    }

    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    public String getDogBreedCode() {
        return dogBreedCode;
    }

    public void setDogBreedCode(String dogBreedCode) {
        this.dogBreedCode = dogBreedCode;
    }

    public String getBreedCnName() {
        return breedCnName;
    }

    public void setBreedCnName(String breedCnName) {
        this.breedCnName = breedCnName;
    }

    public String getPinyin() {
        return pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}