package com.cku.restful.v1.breeder.dto;

import java.io.Serializable;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel
public class TransferListRequestVo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("页码")
	@Min(value = 0, message = "pageNo需大于0")
	@NotNull(message = "pageNo不能为空")
	private int pageNo;

	@ApiModelProperty("条数")
	@Min(value = 0, message = "pageSize需大于0")
	@NotNull(message = "pageSize不能为空")
	private int pageSize;
	
	@ApiModelProperty("1:我的申请 2:等我审核")
	@NotNull(message = "type不能为空")
	private String type;
	
	@ApiModelProperty(hidden = true)
	private String memberCode;
}
