package com.cku.restful.external.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.restful.v1.sys.service.CkuMemberServide;

import net.sf.json.JSONObject;

/**
 * 
 * <p>Title:CkuMemberControllerV2 </p>
 * <p>Description: 外部客服系统使用</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2017年3月20日 上午11:21:26
 */
@Controller
@RequestMapping(value = "/api/v1/open/external")
public class ExternalController {

	@Autowired
	public CkuMemberServide ckuMemberServide;
	
	/**
	 * 
	 * @Description：根据手机号获取会员信息
	 * @author: zhuoHeng
	 * @version: 2017年3月20日 上午11:22:17
	 */
	@RequestMapping(value = "/getClientInfo", method = RequestMethod.POST)
	@ResponseBody
	public void getClientInfo(@RequestBody String json,HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/html");
		JSONObject result = ckuMemberServide.getClientInfo(json);
		response.getWriter().write(result.toString());
	}
}
